class PBFieldNote
  attr_accessor :fieldeffect
  attr_accessor :text
  attr_accessor :elaboration
  attr_accessor :cogwheeltext

  def initialize(fieldeffect, text, elaboration = "", cogwheeltext = "")
    @fieldeffect = fieldeffect
    @text = text
    @elaboration = elaboration
    @cogwheeltext = cogwheeltext
  end
end

def feToStringName(fieldeffect,dig1,dig2=nil)
  return getMoveName(FIELDEFFECTS.dig(fieldeffect, dig1)) if dig1 == :naturePower
  if dig2.nil?
    return FIELDEFFECTS.dig(fieldeffect, dig1).map {|id| getMoveName(id) }.sort.uniq.join(", ")
  else
    #FIELDEFFECTS.dig(fieldeffect, dig1, dig2).map{|id| puts getMoveName(id) }  #uncomment when things bork, posts all moves from each call. the last one printed 
    return FIELDEFFECTS.dig(fieldeffect, dig1, dig2).map {|id| getMoveName(id)}.sort.uniq.join(", ")    #is the last good one before the problem child.
  end
end

### General syntax ########################################################################
#up by x1.5                <icon=fieldUp> <c=green>x1.5</c>
#down by 0.5               <icon=fieldDown> <c=red>x0.5</c>
#green                     <c=green></c>
#red                       <c=red></c>         (actually crimson bc funny) (hi ily)
#orange                    <c=orange></c>
#field general             <icon=field>
#field change              <icon=fieldChange>
#field up                  <icon=fieldUp>
#field down                <icon=fieldDown>
#field plus                <icon=fieldPlus>
#type boosted              PBFieldNote.new(1,"<icon=typeELECTRIC> attacks <icon=fieldUp> <c=green>x1.5</c> when . . .","...when attacker is grounded."),
#attacks boosted           PBFieldNote.new(1,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",FIELDEFFECTS.dig(:ELECTERRAIN, :damageMods, 1.5)),
#attacks weakened          PBFieldNote.new(1,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ",FIELDEFFECTS.dig(:ELECTERRAIN, :damageMods, 0.5)),


# arguments for PBFieldNote are as followed:
# 1: which field the field note belongs to
# 2: The text that's on screen explaining a field phenomenon
# 3: Elaboration on the field phenomenon if no space was left on screen (optional)
# 4: text that appears to the right which shows what stage of field it happens (optional)

def fieldIDToSym(id)
  return {
    1 => :ELECTERRAIN,
    2 => :GRASSY,
    3 => :MISTY,
    4 => :PSYTERRAIN,
    5 => :BURNING,
    6 => :SWAMP,
    7 => :RAINBOW,
    8 => :CORROSIVE,
    9 => :CORROSIVEMIST,
    10 => :DESERT,
    11 => :ICY,
    12 => :ROCKY,
    13 => :FOREST,
    14 => :SUPERHEATED,
    15 => :FACTORY,
    16 => :SHORTCIRCUIT,
    17 => :DARKNESS1,
    18 => :ASHENBEACH,
    19 => :WATERSURFACE,
    20 => :UNDERWATER,
    21 => :CAVE,
    22 => :CLOUDS,
    23 => :CRYSTALCAVERN,
    24 => :MURKWATERSURFACE,
    25 => :MOUNTAIN,
    26 => :SNOWYMOUNTAIN,
    27 => :HOLY,
    28 => :FAIRYTALE,
    29 => :DRAGONSDEN,
    30 => :FLOWERGARDEN1,
    31 => :STARLIGHT,
    32 => :INVERSE,
    33 => :CHESS,
    34 => :WASTELAND,
    35 => :GLITCH,
    36 => :CROWD,
    37 => :DANCEFLOOR,
  }[id]
end

def compileFieldNotes
  
	File.open("Scripts/"+GAMEFOLDER+"/fieldtxt.rb"){|f| eval(f.read)}
  all_field_notes = [
  #Electric Field
    PBFieldNote.new(1,"<c=orange>\"#{FIELDEFFECTS.dig(:ELECTERRAIN, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(1,"Grounded Pokémon <icon=fieldChange> <icon=fieldNoSleep> "),
    PBFieldNote.new(1,"<c=green>Created</c> by . . .","Electric Surge, Electric Terrain (5 turns), Stoked Sparksurfer, Ion Deluge (3 turns), Plasma Fists (3 turns), when the attacker does not hold an Everstone."),
    PBFieldNote.new(1,"<icon=typeELECTRIC> attacks <icon=fieldUp> <c=green>x1.5</c> when . . .","...when attacker is grounded."),
    PBFieldNote.new(1,"Certain attacks <icon=fieldPlus> <icon=typeELECTRIC> . . . ",feToStringName(:ELECTERRAIN,:typeMods,:ELECTRIC)),
    PBFieldNote.new(1,"Focus Punch will always <c=red>fail</c> "),
    PBFieldNote.new(1,"Certain stat moves effect <icon=fieldUp> . . . ","Charge, Eerie Impulse"),
    PBFieldNote.new(1,"Magnet Rise lasts <c=green>8</c> turns"),
    PBFieldNote.new(1,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:ELECTERRAIN,:damageMods, 1.5)),
    PBFieldNote.new(1,"Certain attacks <icon=fieldUp> <c=green>x2</c> . . . ",feToStringName(:ELECTERRAIN, :damageMods, 2.0)),
    PBFieldNote.new(1,"<c=green>Activates</c> Surge Surfer"),
    PBFieldNote.new(1,"<c=green>Activates</c> Motor Drive . . .", "...each turn."),
    PBFieldNote.new(1,"<c=red>Disables</c> Comatose"),
    PBFieldNote.new(1,"Slow Start timer <icon=fieldChange> <c=green>x2</c> per turn"),
    PBFieldNote.new(1,"Galvanize power boost <icon=fieldChange> <c=green>x1.5</c> "),
    PBFieldNote.new(1,"Wild Charge <icon=fieldChange> <c=green>no recoil</c> "),
    PBFieldNote.new(1,"<c=red>Destroyed</c> by these moves . . .", feToStringName(:ELECTERRAIN, :fieldChange, :INDOOR)),
    PBFieldNote.new(1,"Nature Power <icon=fieldChange> #{feToStringName(:ELECTERRAIN, :naturePower)}"),
    PBFieldNote.new(1,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:ELECTERRAIN, :mimicry))}> "),
    PBFieldNote.new(1,"Secret Power <icon=fieldChange> <icon=fieldParalyze> "),
    PBFieldNote.new(1,"Activates <c=orange>Elemental Seed</c>. . .","Boosts Speed and applies Charge to the user."),
  #Grassy Terrain
    PBFieldNote.new(2,"<c=orange>\"#{FIELDEFFECTS.dig(:GRASSY, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(2,"Pokémon <icon=fieldPlus> <c=green>1/16 HP</c> when . . .", "...when grounded"),
    PBFieldNote.new(2,"<c=green>Created</c> by . . .","Grassy Surge, Grassy Terrain (5 turns), Bloom Doom when not in Forest or Flower Garden fields (3 turns)"),
    PBFieldNote.new(2,"<icon=fieldGrass> attacks <icon=fieldUp> <c=green>x1.5</c> when . . .","...when attacker is grounded."),
    PBFieldNote.new(2,"<icon=typeFIRE> attacks <icon=fieldUp> <c=green>x1.5</c> when . . .","...when target is grounded."),
    PBFieldNote.new(2,"<c=green>Activates</c> Grass Pelt"),
    PBFieldNote.new(2,"Sap Sipper <icon=fieldChange> . . .","Heals <c=green>1/16 HP</c> each turn."),
    PBFieldNote.new(2,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:GRASSY, :damageMods, 1.5)),
    PBFieldNote.new(2,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ",feToStringName(:GRASSY, :damageMods, 0.5)),
    PBFieldNote.new(2,"Grass Whistle's Accuracy <icon=fieldChange> <c=green>80</c> "),
    PBFieldNote.new(2,"Certain stat moves' effect <icon=fieldUp> . . .","Coil, Growth"),
    PBFieldNote.new(2,"Nature's Madness damage <icon=fieldChange> <c=green>75 % HP</c> "),
    PBFieldNote.new(2,"Floral Healing heals <c=green>100 %</c> Max HP"),
    PBFieldNote.new(2,"Becomes <c=orange>Burning Field</c> when . . .", "...when #{feToStringName(:GRASSY, :fieldChange, :BURNING)} is used in the absence of Rain or Water Sport."),
    PBFieldNote.new(2,"Becomes <c=orange>Corrosive Field</c> when . . .", "...when #{feToStringName(:GRASSY, :fieldChange, :CORROSIVE)} is used."),
    PBFieldNote.new(2,"Nature Power <icon=fieldChange> #{feToStringName(:GRASSY, :naturePower)}"),
    PBFieldNote.new(2,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:GRASSY, :mimicry))}> "),
    PBFieldNote.new(2,"Secret Power <icon=fieldChange> <icon=fieldSleep> "),
    PBFieldNote.new(2,"Activates <c=orange>Elemental Seed</c>. . .","Boosts Defense and applies Ingrain to the user."),
  #Misty Terrain
    PBFieldNote.new(3,"<c=orange>\"#{FIELDEFFECTS.dig(:MISTY, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(3,"Grounded Pokémon <c=red>immune</c> to status"),
    PBFieldNote.new(3,"<c=green>Created</c> by . . .","Misty Surge, Misty Terrain (5 turns), Mist (3 turns), when the attacker does not hold an Everstone."),
    PBFieldNote.new(3,"<icon=typeDRAGON> attacks <icon=fieldDown> <c=red>x0.5</c> "),
    PBFieldNote.new(3,"<icon=typeFAIRY> Pokémon's Sp.Def <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(3,"<c=green>Activates</c> Marvel Scale"),
    PBFieldNote.new(3,"Dry Skin slowly <c=green>restores HP</c> "),
    PBFieldNote.new(3,"Pixilate power boost <icon=fieldChange> <c=green>x1.5</c> "),
    PBFieldNote.new(3,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:MISTY, :damageMods, 1.5)),
    PBFieldNote.new(3,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ",feToStringName(:MISTY, :damageMods, 0.5)),
    PBFieldNote.new(3,"Soul Heart also <c=green>boosts</c> Sp.Def"),
    PBFieldNote.new(3,"Certain stat moves' effect <icon=fieldUp> . . . ","Aromatic Mist, Cosmic Power"),
    PBFieldNote.new(3,"Sweet Scent <c=red>lowers</c> Def & Sp.Def"),
    PBFieldNote.new(3,"Wish recovery <icon=fieldChange> <c=green>75 % HP</c> "),
    PBFieldNote.new(3,"Aqua Ring recovery <icon=fieldChange> <c=green>1/8 HP</c> "),
    PBFieldNote.new(3,"<c=red>Destroyed</c> by these moves . . .", feToStringName(:MISTY, :fieldChange, :INDOOR)),
    PBFieldNote.new(3,"Becomes <c=orange>Corrosive Mist</c> when . . .", "...when Acid Downpour is used, or when one of these moves is used twice: Clear Smog, Poison Gas, Smog"),
    PBFieldNote.new(3,"<c=red>Prevents</c> use of these moves . . .","Explosion, Mind Blown, Self-Destruct"),
    PBFieldNote.new(3,"<c=green>Activates</c> Water Compaction when . . .","...when Pokémon is sent out."),
    PBFieldNote.new(3,"Nature Power <icon=fieldChange> #{feToStringName(:MISTY, :naturePower)}"),
    PBFieldNote.new(3,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:MISTY, :mimicry))}> "),
    PBFieldNote.new(3,"Secret Power <icon=fieldChange> <c=red>lowers</c> Sp.Atk"),
    PBFieldNote.new(3,"Activates <c=orange>Elemental Seed</c>. . .","Boosts Sp.Def and applies Wish to the user."),
  #Psychic Field
    PBFieldNote.new(4,"<c=orange>\"#{FIELDEFFECTS.dig(:PSYTERRAIN, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(4,"Priority attacks <c=red>fail</c> when . . .","...when used on grounded targets."),
    PBFieldNote.new(4,"<c=green>Created</c> when . . .","...when one of these effects is activated: Psychic Surge, Psychic Terrain, Genesis Supernova (5 turns)"),
    PBFieldNote.new(4,"<icon=fieldPsychic> attacks <icon=fieldUp> <c=green>x1.5</c> when . . .","...when attacker is grounded."),
    PBFieldNote.new(4,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:PSYTERRAIN, :damageMods, 1.5)),
    PBFieldNote.new(4,"Pure Power boost <icon=fieldChange> Sp.Atk"),
    PBFieldNote.new(4,"Anticipation <c=green>boosts</c> Sp.Atk"),
    PBFieldNote.new(4,"Telepathy <c=green>boosts</c> Speed <c=green>x2</c> "),
    PBFieldNote.new(4,"Certain stat moves' effect <icon=fieldUp> . . .","Calm Mind, Cosmic Power, Kinesis, Meditate, Nasty Plot"),
    PBFieldNote.new(4,"Certain attacks <icon=fieldPlus> <c=green>boost</c> Sp.Atk . . .","Mind Reader, Miracle Eye, Psych Up boost Sp.Atk two stages"),
    PBFieldNote.new(4,"Hypnosis accuracy <icon=fieldChange> <c=green>90</c> "),
    PBFieldNote.new(4,"Kinesis <icon=fieldPlus> <icon=fieldUp> Attack/Sp.Atk"),
    PBFieldNote.new(4,"Telekinesis <icon=fieldPlus> <icon=fieldDown> . . .", "... drops opponents' Defense/Sp.Def by two stages"),
    PBFieldNote.new(4,"Certain moves' effect <icon=fieldChange> <c=green>8</c> turns","Gravity, Magic Room, Trick Room, Wonder Room"),
    PBFieldNote.new(4,"Shattered Psyche <icon=fieldPlus> confuses"),
    PBFieldNote.new(4,"Nature Power <icon=fieldChange> #{feToStringName(:PSYTERRAIN, :naturePower)}"),
    PBFieldNote.new(4,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:PSYTERRAIN, :mimicry))}> "),
    PBFieldNote.new(4,"Secret Power <icon=fieldChange> may confuse"),
    PBFieldNote.new(4,"Activates <c=orange>Magical Seed</c> . . .","Boosts Sp.Atk by two stages, but confuses the user."),
  #Burning Field
    PBFieldNote.new(5,"<c=orange>\"#{FIELDEFFECTS.dig(:BURNING, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(5,"End of turn <icon=typeFIRE> <c=orange>damage</c> when . . .","...when grounded and not Fire type."),
    PBFieldNote.new(5,"<c=green>Immunity</c> to <c=orange>field damage</c> when . . .", "...when one of these abilities is active: Flame Body, Flare Boost, Flash Fire, Heatproof, Magma Armor, Water Bubble, Water Veil."),
    PBFieldNote.new(5,"<c=orange>Field damage</c> <icon=fieldUp> when . . .","...when one of these abilities is active: Fluffy, Grass Pelt, Ice Body, Leaf Guard"),
    PBFieldNote.new(5,"<c=green>Created</c> by Grass <icon=fieldPlus> Fire Pledge"),
    PBFieldNote.new(5,"<icon=typeFIRE> attacks <icon=fieldUp> <c=green>x1.5</c> when . . .","...when attacker is grounded."),
    PBFieldNote.new(5,"<icon=fieldGrass> attacks <icon=fieldDown> <c=red>x0.5</c> when . . .","...when target is grounded."),
    PBFieldNote.new(5,"<icon=fieldIce> attacks <icon=fieldDown> <c=red>x0.5</c> "),
    PBFieldNote.new(5,"<c=red>Destroyed</c> by these moves . . .",feToStringName(:BURNING, :fieldChange, :INDOOR)),
    PBFieldNote.new(5,"<c=red>Destroyed</c> by Sand and Rain"),
    PBFieldNote.new(5,"<c=green>Activates</c> certain abilities . . .","Blaze, Flare Boost, Flash Fire"),
    PBFieldNote.new(5,"Will-O-Wisp's Accuracy <icon=fieldChange> <c=green>100</c> "),
    PBFieldNote.new(5,"Pokémon cannot be <c=red>frozen</c> "),
    PBFieldNote.new(5,"Smokescreen effect <icon=fieldUp> "),
    PBFieldNote.new(5,"Fire Spin damage <icon=fieldChange> <c=green>1/6 HP</c> "),
    PBFieldNote.new(5,"Certain attacks <icon=fieldPlus> <icon=typeFIRE> . . . ",feToStringName(:BURNING, :typeMods, :FIRE)),
    PBFieldNote.new(5,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:BURNING, :damageMods, 1.5)),
    PBFieldNote.new(5,"Certain attacks <icon=fieldUp> <c=green>x2</c> . . . ",feToStringName(:BURNING, :damageMods, 2.0)),
    PBFieldNote.new(5,"<c=green>Restores</c> <icon=typeFIRE> after Burn Up"),
    PBFieldNote.new(5,"Nature Power <icon=fieldChange> #{feToStringName(:BURNING, :naturePower)}"),
    PBFieldNote.new(5,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:BURNING, :mimicry))}> "),
    PBFieldNote.new(5,"Secret Power <icon=fieldChange> <icon=fieldBurn> "),
    PBFieldNote.new(5,"Activates <c=orange>Elemental Seed</c>. . .","Boosts Attack, Special Attack and Speed, but applies Fire Spin to the user."),
  #Swamp Field
    PBFieldNote.new(6,"<c=orange>\"#{FIELDEFFECTS.dig(:SWAMP, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(6,"Pokémon's Speed <icon=fieldDown> each turn."),
    PBFieldNote.new(6,"Pokémon <c=red>immune</c> to <c=orange>slow</c> when . . .", "...when airborne."),
    PBFieldNote.new(6,"<c=green>Created</c> by Water <icon=fieldPlus> Grass Pledge"),
    PBFieldNote.new(6,"Ingrain <c=red>damages</c> user unless . . .", "...unless user has Poison or Steel type."),
    PBFieldNote.new(6,"Dry Skin slowly <c=green>restores HP</c> "),
    PBFieldNote.new(6,"Aqua Ring recovery <icon=fieldChange> <c=green>1/8 HP</c> "),
    PBFieldNote.new(6,"<icon=typePOISON> attacks <icon=fieldUp> <c=green>x1.5</c> when. . .","...when target is grounded."),
    PBFieldNote.new(6,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:SWAMP, :damageMods, 1.5)),
    PBFieldNote.new(6,"Certain attacks <icon=fieldDown> <c=red>x0.25</c> . . . ",feToStringName(:SWAMP, :damageMods, 0.25)),
    PBFieldNote.new(6,"Certain attacks <icon=fieldPlus> <icon=typeWATER> . . . ",feToStringName(:SWAMP, :typeMods, :WATER)),
    PBFieldNote.new(6,"<c=red>Prevents</c> use of these moves . . .","Explosion, Mind Blown, Self-Destruct"),
    PBFieldNote.new(6,"Sleep Powder's Accuracy <icon=fieldChange> <c=green>100</c> "),
    PBFieldNote.new(6,"<icon=fieldSleep> Pokémon <c=red>damaged</c> each turn"),
    PBFieldNote.new(6,"Gooey effect <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(6,"<c=green>Activates</c> Water Compaction . . .", "...each turn."),
    PBFieldNote.new(6,"Strength Sap recovery <icon=fieldUp> <c=green>30 %</c> "),
    PBFieldNote.new(6,"Nature Power <icon=fieldChange> #{feToStringName(:SWAMP, :naturePower)}"),
    PBFieldNote.new(6,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:SWAMP, :mimicry))}> "),
    PBFieldNote.new(6,"Secret Power <icon=fieldChange> <c=red>lowers</c> Speed"),
    PBFieldNote.new(6,"Activates <c=orange>Telluric Seed</c>. . .","Boosts Defense and Sp.Def and applies Ingrain to the user."),
  #Rainbow Field
    PBFieldNote.new(7,"<c=orange>\"#{FIELDEFFECTS.dig(:RAINBOW, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(7,"Secondary effect chance <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(7,"<c=green>Created</c> by Fire <icon=fieldPlus> Water Pledge"),
    PBFieldNote.new(7,"<c=green>Created</c> by Sun <icon=fieldPlus> Rain"),
    PBFieldNote.new(7,"Cloud Nine slowly <c=green>boosts</c> stats"),
    PBFieldNote.new(7,"<c=green>Activates</c> Marvel Scale"),
    PBFieldNote.new(7,"Wonder Skin always <c=green>activates</c> "),
    PBFieldNote.new(7,"Special <icon=typeNORMAL> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(7,"Special <icon=typeNORMAL> attacks <icon=fieldPlus> <icon=typeQMARK> ","Special Normal attacks gain a random type."),
    PBFieldNote.new(7,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:RAINBOW, :damageMods, 1.5)),
    PBFieldNote.new(7,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ",feToStringName(:RAINBOW, :damageMods, 0.5)),
    PBFieldNote.new(7,"Certain stat moves' effect <icon=fieldUp> . . . ","Cosmic Power, Meditate"),
    PBFieldNote.new(7,"Certain attacks <icon=fieldChange> <c=green>no charge turn</c> ","Solar Beam, Solar Blade"), 
    PBFieldNote.new(7,"Wish recovery <icon=fieldChange> <c=green>75 % HP</c> "),
    PBFieldNote.new(7,"Nightmare and Bad Dreams <c=red>fail</c> "),
    PBFieldNote.new(7,"<icon=fieldSleep> Pokémon <c=green>recover</c> each turn"),
    PBFieldNote.new(7,"Sonic Boom damage <icon=fieldChange> <c=green>140</c> "),
    PBFieldNote.new(7,"<c=red>Destroyed</c> when . . .","...when Sand or Hail are in effect, or Light That Burns The Sky is used."),
    PBFieldNote.new(7,"<c=green>Enables</c> Aurora Veil"),
    PBFieldNote.new(7, "Soul Heart also <c=green>boosts</c> Sp.Def"),
    PBFieldNote.new(7,"Prism Armor <c=green>lowers damage</c> x0.75"),
    PBFieldNote.new(7,"Nature Power <icon=fieldChange> #{feToStringName(:RAINBOW, :naturePower)}"),
    PBFieldNote.new(7,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:RAINBOW, :mimicry))}> "),
    PBFieldNote.new(7,"Secret Power <icon=fieldChange> random status"),
    PBFieldNote.new(7,"Activates <c=orange>Magical Seed</c>. . .","Boosts Sp.Atk and applies Wish to the user."),
  #Corrosive Field
    PBFieldNote.new(8,"<c=orange>\"#{FIELDEFFECTS.dig(:CORROSIVE, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(8,"Deals <icon=typePOISON> <c=orange>hazard damage</c> when . . .","...when grounded."),
    PBFieldNote.new(8,"No <c=orange>hazard damage</c> when . . .", "...when  Poison or Steel type, or one of these abilities is active: Immunity, Poison Heal, Toxic Boost, Wonder Guard" ),
    PBFieldNote.new(8,"Ingrain <c=red>damages</c> user unless . . .","...unless Poison or Steel type."),
    PBFieldNote.new(8,"Grass Pelt <c=red>damages</c> user unless","...unless Poison or Steel type."),
    PBFieldNote.new(8,"<c=green>Activates</c> certain abilities when . . .","...when grounded, activates Poison Heal and Toxic Boost."),
    PBFieldNote.new(8,"<icon=fieldGrass> attacks <icon=fieldPlus> <icon=typePOISON> "),
    PBFieldNote.new(8,"Certain attacks <icon=fieldPlus> <icon=typePOISON> . . . ",feToStringName(:CORROSIVE, :typeMods, :POISON)),
    PBFieldNote.new(8,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:CORROSIVE, :damageMods, 1.5)),
    PBFieldNote.new(8,"Certain attacks <icon=fieldUp> <c=green>x2</c> . . . ",feToStringName(:CORROSIVE, :damageMods, 2.0)),
    PBFieldNote.new(8,"Certain stat moves' effect <icon=fieldUp> . . . ","Acid Armor"),
    PBFieldNote.new(8,"<c=green>Activates</c> Venom Drench"),
    PBFieldNote.new(8,"<c=green>Activates</c> Venoshock"),
    PBFieldNote.new(8,"Certain moves' Accuracy <icon=fieldChange> <c=green>100</c> ","Poison Powder, Sleep Powder, Stun Spore, Toxic"),
    PBFieldNote.new(8,"<icon=fieldSleep> Pokémon <c=red>damaged</c> unless . . .", "...unless Poison or Steel Type, or has Wonder Guard."),
    PBFieldNote.new(8,"Toxic Spikes <c=red>can't</c> be absorbed"),
    PBFieldNote.new(8,"Becomes <c=orange>Grassy Terrain</c> when . . .","...when Seed Flare is used."),
    PBFieldNote.new(8,"<c=green>Activates</c> Merciless"),
    PBFieldNote.new(8,"Corrosion damage <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(8,"Floral Healing <icon=fieldPlus> <icon=fieldPoisonStatus> "),
    PBFieldNote.new(8,"Nature Power <icon=fieldChange> #{feToStringName(:CORROSIVE, :naturePower)}"),
    PBFieldNote.new(8,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:CORROSIVE, :mimicry))}> "),
    PBFieldNote.new(8,"Secret Power <icon=fieldChange> <icon=fieldPoisonStatus> "),
    PBFieldNote.new(8,"Activates <c=orange>Telluric Seed</c> . . .","Applies Baneful Bunker to the user."),
  # Corrosive Mist Field
    PBFieldNote.new(9,"<c=orange>\"#{FIELDEFFECTS.dig(:CORROSIVEMIST, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(9,"All Pokémon get <icon=fieldPoisonStatus> each turn"),
    PBFieldNote.new(9,"Aqua Ring <c=red>damages</c> user unless . . .", "...unless Poison or Steel type."),
    PBFieldNote.new(9,"Dry Skin <c=red>damages</c> user unless . . .", "...unless Poison or Steel type."),
    PBFieldNote.new(9,"Certain attacks <icon=fieldPlus> <icon=typePOISON> . . . ","All special Flying moves, " + feToStringName(:CORROSIVEMIST, :typeMods, :POISON)),
    PBFieldNote.new(9,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:CORROSIVEMIST, :damageMods, 1.5)),
    PBFieldNote.new(9,"Certain stat moves' effect <icon=fieldUp> . . . ","Acid Armor"),
    PBFieldNote.new(9,"<c=green>Activates</c> Venom Drench"),
    PBFieldNote.new(9,"<c=green>Activates</c> Venoshock"),
    PBFieldNote.new(9,"Toxic's Accuracy <icon=fieldChange> <c=green>100</c> "),
    PBFieldNote.new(9,"Aftermath damage <icon=fieldChange> <c=green>50 % HP</c> "),
    PBFieldNote.new(9,"<icon=typeFIRE> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(9,"<c=green>Activates</c> Merciless"),
    PBFieldNote.new(9,"Corrosion damage <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(9,"Floral Healing <icon=fieldPlus> <icon=fieldPoisonStatus> "),
    PBFieldNote.new(9,"<c=green>Activates</c> Water Compaction . . .","...each turn."),
    PBFieldNote.new(9,"<c=red>Destroyed</c> by these moves . . .",feToStringName(:CORROSIVEMIST, :fieldChange, :INDOOR)),
    PBFieldNote.new(9,"All Pokémon <icon=fieldFaint> when . . .", "...unless they have Flash Fire, when one of these moves is used in the absence of Damp: " + (PBFields::IGNITEMOVES + [:SELFDESTRUCT, :EXPLOSION]).map {|id| getMoveName(id)}.sort.join(", ")),
    PBFieldNote.new(9,"Becomes <c=orange>Corrosive Field</c> when . . .","...when Gravity is used."),
    PBFieldNote.new(9,"Becomes <c=orange>Misty Terrain</c> when . . .","...when Seed Flare is used."),
    PBFieldNote.new(9,"Nature Power <icon=fieldChange> #{feToStringName(:CORROSIVEMIST, :naturePower)}"),
    PBFieldNote.new(9,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:CORROSIVEMIST, :mimicry))}> "),
    PBFieldNote.new(9,"Secret Power <icon=fieldChange> <icon=fieldPoisonStatus> "),
    PBFieldNote.new(9,"Activates <c=orange>Elemental Seed</c> . . .","Boosts Attack and Sp.Atk and badly poisons the user."),
  #Desert Field
    PBFieldNote.new(10,"<c=orange>\"#{FIELDEFFECTS.dig(:DESERT, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(10,"<icon=fieldGround> Pokémon's Sp.Def <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(10,"<c=green>Activates </c> certain abilities . . .","Sand Force, Sand Rush, Sand Veil"),
    PBFieldNote.new(10,"Sun and Sand last <c=green>8</c> turns"),
    PBFieldNote.new(10,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:DESERT, :damageMods, 1.5)),
    PBFieldNote.new(10,"Sand Attack's effect <icon=fieldUp> "),
    PBFieldNote.new(10,"Dry Skin <c=red>damages</c> user"),
    PBFieldNote.new(10,"Sand Tomb damage <icon=fieldChange> <c=green>1/6 HP</c> per turn"),
    PBFieldNote.new(10,"<icon=typeWATER> attacks <icon=fieldDown> <c=red>x0.5</c> when . . .","...when attacker is grounded."),
    PBFieldNote.new(10,"<icon=typeELECTRIC> attacks <icon=fieldDown> <c=red>x0.5</c> when . . .","...when target is grounded."),
    PBFieldNote.new(10,"Shore Up heals <c=green>100 %</c> Max HP"),
    PBFieldNote.new(10,"Nature Power <icon=fieldChange> #{feToStringName(:DESERT, :naturePower)}"),
    PBFieldNote.new(10,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:DESERT, :mimicry))}> "),
    PBFieldNote.new(10,"Secret Power <icon=fieldChange> <c=red>lowers</c> Accuracy"),
    PBFieldNote.new(10,"Activates <c=orange>Telluric Seed</c> . . .","Boosts Defense, Sp.Def, and Speed but applies Sand Tomb to the user."),
  #Icy Field
    PBFieldNote.new(11,"<c=orange>\"#{FIELDEFFECTS.dig(:ICY, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(11,"Certain moves <c=green>boost</c> speed when . . .","...when attacker is grounded, these moves boost Speed: All attacking physical contact priority moves, Defense Curl, Feint, Lunge, Rollout, Steamroller"),
    PBFieldNote.new(11,"<icon=fieldIce> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(11,"<icon=typeFIRE> attacks <icon=fieldDown> <c=red>x0.5</c> "),
    PBFieldNote.new(11,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ",feToStringName(:ICY, :damageMods, 0.5)),
    PBFieldNote.new(11,"<icon=typeROCK> attacks <icon=fieldPlus> <icon=fieldIce> "),
    PBFieldNote.new(11,"<icon=fieldIce> Pokémon's Defense <icon=fieldUp> <c=green>x1.5</c> when . . .", "...when Hail is up"),
    PBFieldNote.new(11,"<icon=fieldBurn> damage <icon=fieldDown> <c=red>x0.5</c> "),
    PBFieldNote.new(11,"Becomes <c=orange>Water Surface</c> when . . .", "...when #{feToStringName(:ICY, :fieldChange, :WATERSURFACE)} is used, or if Water Surface is already under the ice and #{PBFields::QUAKEMOVES.map {|id| getMoveName(id)}.sort.join(", ")} is used. Also turns into Water Surface if Scald or Steam Eruption is used twice."),
    PBFieldNote.new(11,"<c=green>Creates</c> a layer of spikes when . . .", "...when one of these moves is used and Water Surface isn't beneath the ice: #{PBFields::QUAKEMOVES.map {|id| getMoveName(id)}.sort.join(", ")}."),
    PBFieldNote.new(11,"Hail lasts <c=green>8</c> turns"),
    PBFieldNote.new(11,"<c=green>Activates</c> certain abilities . . .","Ice Body, Snow Cloak, Slush Rush"),
    PBFieldNote.new(11,"Refrigerate power boost <icon=fieldChange> <c=green>x1.5</c> "),
    PBFieldNote.new(11,"<c=green>Enables</c> Aurora Veil"),
    PBFieldNote.new(11,"Liquid Voice <icon=fieldChange> <icon=fieldIce> "),
    PBFieldNote.new(11,"Nature Power <icon=fieldChange> #{feToStringName(:ICY, :naturePower)}"),
    PBFieldNote.new(11,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:ICY, :mimicry))}> "),
    PBFieldNote.new(11,"Secret Power <icon=fieldChange> <icon=fieldFreeze> "),
    PBFieldNote.new(11,"Activates <c=orange>Elemental Seed</c> . . .","Boosts Speed two stages, but damages the user with Spikes."),
  #Rocky Field
    PBFieldNote.new(12,"<c=orange>\"#{FIELDEFFECTS.dig(:ROCKY, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(12,"Pokémon can <c=orange>dodge</c> when . . .", "...when Defense is increased or Substitute is up, attacks that can be blocked by Bulletproof can be dodged behind rocks."),
    PBFieldNote.new(12,"Missed contact moves <c=orange>recoil</c> . . .","...unless user has Rock Head."),
    PBFieldNote.new(12,"Stealth Rock damage <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(12,"Flinched Pokémon take <c=orange>recoil</c> . . .", "...unless target has Steadfast or Sturdy."),
    PBFieldNote.new(12,"<c=green>Prevents</c> flinches when . . .", "...when Defense is increased."),
    PBFieldNote.new(12,"Certain attacks <icon=fieldPlus> <icon=typeROCK> . . .",feToStringName(:ROCKY, :typeMods, :ROCK)),
    PBFieldNote.new(12,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:ROCKY, :damageMods, 1.5)),
    PBFieldNote.new(12,"<icon=typeROCK> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(12,"Rock Smash <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(12,"Rock Polish's effect <icon=fieldUp> "),
    PBFieldNote.new(12,"Long Reach accuracy <icon=fieldDown> <c=red>x0.9</c> "),
    PBFieldNote.new(12,"Nature Power <icon=fieldChange> #{feToStringName(:ROCKY, :naturePower)}"),
    PBFieldNote.new(12,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:ROCKY, :mimicry))}> "),
    PBFieldNote.new(12,"Secret Power <icon=fieldChange> Flinches"),
    PBFieldNote.new(12,"Activates <c=orange>Telluric Seed</c> . . .","Boosts Defense, but damages the user with Stealth Rocks."),
  #Forest Field
    PBFieldNote.new(13,"<c=orange>\"#{FIELDEFFECTS.dig(:FOREST, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(13,"Effect Spore chance <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(13,"<c=green>Activates</c> certain abilities . . .", "Grass Pelt, Leaf Guard, Overgrow, Swarm"),
    PBFieldNote.new(13,"<icon=fieldGrass> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(13,"Special <icon=typeBUG> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(13,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:FOREST, :damageMods, 1.5)),
    PBFieldNote.new(13,"Cut <icon=fieldChange> <c=green>x2</c> vs <icon=fieldGrass> " ),
    PBFieldNote.new(13,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ",feToStringName(:FOREST, :damageMods, 0.5)),
    PBFieldNote.new(13,"Sap Sipper slowly <c=green>restores HP</c> "),
    PBFieldNote.new(13,"Ingrain recovery <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(13,"Certain stat moves' effect <icon=fieldUp> . . .","Defend Order, Growth"),
    PBFieldNote.new(13,"Heal Order recovery <icon=fieldChange> <c=green>66 %</c> "),
    PBFieldNote.new(13,"Sticky Web effect <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(13,"Long Reach accuracy <icon=fieldDown> <c=red>x0.9</c> "),
    PBFieldNote.new(13,"Strength Sap recovery <icon=fieldChange> <c=green>66 %</c> "),
    PBFieldNote.new(13,"Nature's Madness damage <icon=fieldChange> <c=green>75 %</c> "),
    PBFieldNote.new(13,"Forest's Curse <icon=fieldPlus> Curse effect"),
    PBFieldNote.new(13,"Becomes a <c=orange>Burning Field</c> when . . .", "...when #{feToStringName(:FOREST, :fieldChange, :BURNING)} is used in the absence of Rain or Water Sport"),
    PBFieldNote.new(13,"Nature Power <icon=fieldChange> #{feToStringName(:FOREST, :naturePower)}"),
    PBFieldNote.new(13,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:FOREST, :mimicry))}> "),
    PBFieldNote.new(13,"Secret Power <icon=fieldChange> <icon=fieldSleep> "),
    PBFieldNote.new(13,"Activates <c=orange>Telluric Seed</c> . . .","Applies Spiky Shield to the user."),
  #Super-Heated Field
    PBFieldNote.new(14,"<c=orange>\"#{FIELDEFFECTS.dig(:SUPERHEATED, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(14,"<icon=typeFIRE> attacks <icon=fieldUp> <c=green>x1.1</c> "),
    PBFieldNote.new(14,"<icon=fieldIce> attacks <icon=fieldDown> <c=red>x0.5</c> "),
    PBFieldNote.new(14,"<icon=typeWATER> attacks <icon=fieldDown> <c=red>x0.9</c> "),
    PBFieldNote.new(14,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ",feToStringName(:SUPERHEATED, :damageMods, 0.625)),
    PBFieldNote.new(14,"Certain moves generate <c=orange>steam</c> . . .","Hydro Vortex, Muddy Water, Oceanic Operetta, Sparkling Aria, Surf, Water Pledge, Water Sport, and Water Spout generate steam, lowering all active Pokémon's Accuracy."),
    PBFieldNote.new(14,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:SUPERHEATED, :damageMods, 1.5)),
    PBFieldNote.new(14,"Becomes <c=orange>Burning Field</c> when . . .","...when #{feToStringName(:SUPERHEATED, :fieldChange, :BURNING)} is used in the absence of Rain or Water Sport."),
    PBFieldNote.new(14,"<c=red>Destroyed</c> by these moves . . .", feToStringName(:SUPERHEATED, :fieldChange, :INDOOR)),
    PBFieldNote.new(14,"Hail is <c=red>terminated</c> "),
    PBFieldNote.new(14,"Attacks fatigue after <c=red>1</c> turn . . .","Applies to Outrage, Petal Dance, and Thrash"),
    PBFieldNote.new(14,"Nature Power <icon=fieldChange> #{feToStringName(:SUPERHEATED, :naturePower)}"),
    PBFieldNote.new(14,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:SUPERHEATED, :mimicry))}> "),
    PBFieldNote.new(14,"Secret Power <icon=fieldChange> <icon=fieldBurn> "),
    PBFieldNote.new(14,"Activates <c=orange>Telluric Seed</c> . . .","Boosts Defense and applies Shell Trap to the user."),
  #Factory Field
    PBFieldNote.new(15,"<c=orange>\"#{FIELDEFFECTS.dig(:FACTORY, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(15,"<icon=typeELECTRIC> attacks <icon=fieldUp> <c=green>x1.2</c> "),
    PBFieldNote.new(15,"Motor Drive boost <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(15,"Download boost <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(15,"Technician applies up to BP <c=green>80</c> "),
    PBFieldNote.new(15,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:FACTORY, :damageMods, 1.5)),
    PBFieldNote.new(15,"Certain attacks <icon=fieldUp> <c=green>x2</c> . . . ",feToStringName(:FACTORY, :damageMods, 2.0)),
    PBFieldNote.new(15,"Certain stat moves' effect <icon=fieldUp> . . .","Autotomize, Iron Defense, Metal Sound, Shift Gear"),
    PBFieldNote.new(15,"Magnet Rise lasts <c=green>8</c> turns"),
    PBFieldNote.new(15,"Becomes <c=orange>Short-Circuit</c> when . . .","...when #{feToStringName(:FACTORY, :fieldChange, :SHORTCIRCUIT)} is used. Discharge additionally can alternate between the Short-Circuit and Factory Fields for each instance of damage in Double Battles."),
    PBFieldNote.new(15,"Gear Up boosts user and <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(15,"Galvanize power boost <icon=fieldChange> <c=green>x1.5</c> "),
    PBFieldNote.new(15,"Steelworker power boost <icon=fieldChange> <c=green>x2</c> "),
    PBFieldNote.new(15,"Nature Power <icon=fieldChange> #{feToStringName(:FACTORY, :naturePower)}"),
    PBFieldNote.new(15,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:FACTORY, :mimicry))}> "),
    PBFieldNote.new(15,"Secret Power <icon=fieldChange> <c=red>lowers</c> Attack"),
    PBFieldNote.new(15,"Activates <c=orange>Synthetic Seed</c> . . .","Boosts Sp.Atk and applies Laser Focus to the user."),
  #Short-Circuit Field
    PBFieldNote.new(16,"<c=orange>\"#{FIELDEFFECTS.dig(:SHORTCIRCUIT, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(16,"Static chance <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(16,"Volt Absorb slowly <c=green>restores HP</c> "),
    PBFieldNote.new(16,"<c=green>Activates</c> Plus and Minus"),
    PBFieldNote.new(16,"<icon=typeELECTRIC> attacks <icon=fieldChange> sequential damage", "Damage rolls set multipliers between x0.5 and x2 on a specific pattern"),
    PBFieldNote.new(16,"Certain attacks <icon=fieldUp> <c=green>x1.3</c> . . . ",feToStringName(:SHORTCIRCUIT, :damageMods, 1.3)),
    PBFieldNote.new(16,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:SHORTCIRCUIT, :damageMods, 1.5)),
    PBFieldNote.new(16,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ",feToStringName(:SHORTCIRCUIT, :damageMods, 0.5)),
    PBFieldNote.new(16,"Certain attacks <icon=fieldPlus> <icon=typeELECTRIC> . . .",feToStringName(:SHORTCIRCUIT, :typeMods, :ELECTRIC)),
    PBFieldNote.new(16,"Becomes <c=orange>Factory Field</c> when . . .","...when #{feToStringName(:SHORTCIRCUIT, :fieldChange, :FACTORY)} is used. Discharge additionally can alternate between the Short-Circuit and Factory Fields for each instance of damage in Double Battles."),
    PBFieldNote.new(16,"Certain stat moves' effect <icon=fieldUp> . . .","Flash, Metal Sound"),
    PBFieldNote.new(16,"Zap Cannon's Accuracy <icon=fieldChange> <c=green>80</c> "),
    PBFieldNote.new(16,"Magnet Rise lasts for <c=green>8</c> turns"),
    PBFieldNote.new(16,"<c=green>Activates</c> Surge Surfer"),
    PBFieldNote.new(16,"Galvanize power boost <icon=fieldChange> <c=green>x2</c> "),
    PBFieldNote.new(16,"Steelworker <icon=fieldPlus> <icon=typeELECTRIC> "),
    PBFieldNote.new(16,"Nature Power <icon=fieldChange> #{feToStringName(:SHORTCIRCUIT, :naturePower)}"),
    PBFieldNote.new(16,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:SHORTCIRCUIT, :mimicry))}> "),
    PBFieldNote.new(16,"Secret Power <icon=fieldChange> <icon=fieldParalyze> "),
    PBFieldNote.new(16,"Activates <c=orange>Synthetic Seed</c> . . .","Boosts Sp.Def and applies Magnet Rise to the user."),
  #Darkness Field
    PBFieldNote.new(17,"<c=orange>\"A shroud of darkness . . .</c> ", "A shroud of darkness, however slight, gently envelops the field..."),
    PBFieldNote.new(17,"Darkness consumes the field . . .", "Darkness consumes the field further, increasing from <c=orange>Stage 1</c> to <c=orange>Stage 3</c> "),
    PBFieldNote.new(17,"Darkness Field begins on <c=orange>Stage 2</c> "),
    PBFieldNote.new(17,"Sunny Weather decreases <c=orange>Stage</c> by 1"),
    PBFieldNote.new(17,"<icon=fieldSleep> lasts 2-4 turns","","<c=ffb347>2+</c> "),
    PBFieldNote.new(17,"Dark Types take reduced damage . . .","Dark Type Pokemon take <c=green>x0.90</c> damage on <c=orange>Stage 2</c> and <c=green>x0.75</c> on <c=orange>Stage 3</c>","<c=ffb347>2+</c> "),
    PBFieldNote.new(17,"Ghost Types take reduced damage . . .","Ghost Type Pokemon take <c=green>x0.90</c> damage on <c=orange>Stage 2</c> and <c=green>x0.75</c> on <c=orange>Stage 3</c>","<c=ffb347>2+</c> "),
    PBFieldNote.new(17,"Dark & Ghost Types weaknesses. . .","<c=red>Annulled</c> on <c=orange>Stage 3</c>","<c=ec5800>3</c>"),
    PBFieldNote.new(17,"Certain attacks <c=orange>boost by</c> 1 <c=orange>Stage</c> . . .","Dark Pulse, Night Daze, Ominous Wind, Moongeist Beam, Astral Barrage"),
    PBFieldNote.new(17,"Certain attacks <c=orange>boost by</c> 2 <c=orange>Stages</c> . . .","Dark Void"),
    PBFieldNote.new(17,"Certain attacks <c=orange>reduce by</c> 1 <c=orange>Stage</c> . . .","Dazzling Gleam, Flash, Flash Cannon, Wish, Luster Purge, Light of Ruin, Photon Geyser"),
    PBFieldNote.new(17,"Certain attacks <c=orange>reduce by</c> 2 <c=orange>Stages</c> . . .","Light that Burns the Sky"),
    PBFieldNote.new(17,"Certain attacks <icon=fieldUp> <c=green>x1.1, x1.2, x1.4</c> . . . ",feToStringName(:DARKNESS1, :damageMods, 1.1),"<c=7CFC00>1+</c> "),
    PBFieldNote.new(17,"Certain attacks <icon=fieldDown> <c=red>x0.9, x0.75, x0.5</c> . . . ",feToStringName(:DARKNESS1, :damageMods, 0.9),"<c=7CFC00>1+</c> "),
    PBFieldNote.new(17,"Dark Surge <icon=fieldChange> . . .","Increases <c=orange>Stage</c> by 1 on <c=orange>Stage 1 & 2</c>, Boosts Speed on <c=orange>Stage 3</c>.","<c=7CFC00>1+</c> "),
    PBFieldNote.new(17,"Certain stat moves' effect <icon=fieldUp> . . . ","Flash","<c=7CFC00>1</c>"),
    PBFieldNote.new(17,"Wish lasts 1 turn","","<c=7CFC00>1</c>"),
    PBFieldNote.new(17,"Last Resort <icon=fieldChange> . . .","Does not require other moves to be used first.","<c=7CFC00>1</c>"),
    PBFieldNote.new(17,"Phantom Force, Shadow Force <icon=fieldChange> . . .","Last 1 turn.","<c=7CFC00>1</c>"), 
    PBFieldNote.new(17,"Rest lasts 2 turns","","<c=ffb347>2+</c> "),
    PBFieldNote.new(17,"Morning Sun/Synthesis heals . . ."," <c=red>25% HP</c> on <c=orange>Stage 2</c>, <c=red>12.5% HP</c> on <c=orange>Stage 3</c>","<c=ffb347>2+</c> "),
    PBFieldNote.new(17,"Solar Beam & Solar Blade always <c=red>fail</c>","","<c=ffb347>2+</c> "),
    PBFieldNote.new(17,"Dark Void's Accuracy <icon=fieldChange> . . .","<c=green>70</c> on <c=orange>Stage 2</c>, <c=green>100</c> on <c=orange>Stage 3</c>","<c=ffb347>2+</c> "),
    PBFieldNote.new(17,"Bad Dreams damage <icon=fieldChange> . . .","<c=green>16%</c> HP on <c=orange>Stage 2</c>, <c=green>25%</c> HP on <c=orange>Stage 3</c>","<c=ffb347>2+</c> "),
    PBFieldNote.new(17,"<c=green>Activates</c> Rattled"),
    PBFieldNote.new(17,"Insomnia <c=red>annulled</c>"),
    PBFieldNote.new(17,"Pickpocket <icon=fieldPlus> <c=green>boosts</c> stats . . .","Pickpocket boosts Speed upon switching in.","<c=ffb347>2+</c> "),
    PBFieldNote.new(17,"Shadow Shield <c=green>reduces</c> damage","Shadow Shield reduces damage of super effective hits by <c=green>0.75</c>.","<c=ffb347>2+</c> "),
    PBFieldNote.new(17,"Fairy Aura <icon=fieldChange> . . .","<c=red>20%</c> on <c=orange>Stage 2</c>, <c=red>10%</c> on <c=orange>Stage 3</c>","<c=ffb347>2+</c> "),
    PBFieldNote.new(17,"Dark Aura <icon=fieldChange> . . .","<c=green>40%</c> on <c=orange>Stage 1</c>, <c=green>50%</c> on <c=orange>Stage 2</c>, <c=green>65%</c> on <c=orange>Stage 3</c>","<c=7CFC00>1+</c> "),
    PBFieldNote.new(17,"Nature Power <icon=fieldChange> #{feToStringName(:DARKNESS1, :naturePower)}"),
    PBFieldNote.new(17,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:DARKNESS1, :mimicry))}> "),
    PBFieldNote.new(17,"Secret Power <icon=fieldChange> <c=red>lowers</c> Defense "),
    PBFieldNote.new(17,"Activates <c=orange>Magical Seed</c> . . .","Increases <c=orange>Stage</c> by 1 on <c=orange>Stage 1 & 2</c>, Boosts Def and Sp.Def on <c=orange>Stage 3</c>."),
    #Ashen Beach
    PBFieldNote.new(18,"<c=orange>\"#{FIELDEFFECTS.dig(:ASHENBEACH, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(18,"Certain attacks stir up <c=orange>ash</c> . . .","All Special Flying attacks, Fire Spin, Leaf Tornado, Razor Wind, Twister, and Whirlpool stir up ash, lowering all active Pokémon's Accuracy."),
    PBFieldNote.new(18,"<icon=typeFIGHTING> Pokémon or Pokémon with . . ."," ...with Inner Focus can't get confused."),
    PBFieldNote.new(18,"Accuracy/Evasion <c=red>ignored</c> when . . .","...when the target does not have Unnerve, and one of these abilities is active: Own Tempo, Pure Power, Sand Veil, Steadfast"),
    PBFieldNote.new(18,"<c=green>Activates</c> certain abilities . . .", "Sand Force, Sand Rush, Sand Veil"),
    PBFieldNote.new(18,"Zen Mode <c=green>always active</c> "),
    PBFieldNote.new(18,"Certain stat moves' effect <icon=fieldUp> . . .","Calm Mind, Kinesis, Meditate, Sand Attack"),
    PBFieldNote.new(18,"Sand lasts <c=green>8</c> turns"),
    PBFieldNote.new(18,"Psych-Up <icon=fieldPlus> <c=green>cures</c> status"),
    PBFieldNote.new(18,"Focus Energy's effect <icon=fieldUp> "),
    PBFieldNote.new(18,"Certain attacks <icon=fieldUp> <c=green>x2</c> . . . ",feToStringName(:ASHENBEACH, :damageMods, 2.0)),
    PBFieldNote.new(18,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:ASHENBEACH, :damageMods, 1.5)),
    PBFieldNote.new(18,"Certain attacks <icon=fieldUp> <c=green>x1.3</c> . . . ",feToStringName(:ASHENBEACH, :damageMods, 1.3)),
    PBFieldNote.new(18,"Psychic <icon=fieldUp> <c=green>x1.2</c> "),
    PBFieldNote.new(18,"Strength <icon=fieldChange> <icon=typeFIGHTING>/<icon=fieldPsychic> damage"),
    PBFieldNote.new(18,"Sand Tomb <icon=fieldPlus> <c=green>lowers</c> Accuracy"),
    PBFieldNote.new(18,"Water Compaction <c=green>boosts</c> Sp.Def"),
    PBFieldNote.new(18,"Focus Blasts's Accuracy <icon=fieldChange> <c=green>90</c> "),
    PBFieldNote.new(18,"Shore Up recovery <icon=fieldChange> <c=green>75 %</c> HP"),
    PBFieldNote.new(18,"Shell Bell recovery <icon=fieldChange> <c=green>25 %</c> damage dealt"),
    PBFieldNote.new(18,"Nature Power <icon=fieldChange> #{feToStringName(:ASHENBEACH, :naturePower)}"),
    PBFieldNote.new(18,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:ASHENBEACH, :mimicry))}> "),
    PBFieldNote.new(18,"Secret Power <icon=fieldChange> <c=red>lowers</c> Accuracy"),
    PBFieldNote.new(18,"Activates <c=orange>Telluric Seed</c> . . .","Applies Focus Energy to the user."),
  #Water Surface
    PBFieldNote.new(19,"<c=orange>\"#{FIELDEFFECTS.dig(:WATERSURFACE, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(19,"Speed <icon=fieldDown> <c=red>x0.75</c> unless <icon=typeWATER> or . . .", "...unless Water type, airborne, or the abilities Surge Surfer or Swift Swim are active."),
    PBFieldNote.new(19,"<c=red>Prevents</c> <icon=fieldGround> attacks"),
    PBFieldNote.new(19,"Spikes/Toxic Spikes <c=red>terminated</c> "),
    PBFieldNote.new(19,"Dive lasts 1 turn"),
    PBFieldNote.new(19,"Water Veil <icon=fieldPlus> <c=green>cures</c> status"),
    PBFieldNote.new(19,"<c=green>Activates</c> certain abilities . . .","Hydration, Schooling, Surge Surfer, Swift Swim, Torrent, and Water Compaction each turn."),
    PBFieldNote.new(19,"Splash <icon=fieldPlus> <c=green>lowers</c> Accuracy"),
    PBFieldNote.new(19,"Aqua Ring recovery <icon=fieldChange> <c=green>1/8 HP</c> "),
    PBFieldNote.new(19,"Certain abilities <c=green>restore HP</c> . . .","Dry Skin, Water Absorb"),
    PBFieldNote.new(19,"Shore Up <c=green>activates</c> Water Compaction"),
    PBFieldNote.new(19,"Whirlpool damage <icon=fieldChange> <c=green>1/6 HP</c> "),
    PBFieldNote.new(19,"Whirlpool <icon=fieldPlus> confuses target"),
    PBFieldNote.new(19,"<icon=typeWATER> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(19,"<icon=typeELECTRIC> attacks <icon=fieldUp> <c=green>x1.5</c> when . . .","...when target is grounded."),   
    PBFieldNote.new(19,"<icon=typeFIRE> attacks <icon=fieldDown> <c=red>x0.5</c> when . . .","...when target is grounded."),
    PBFieldNote.new(19,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:WATERSURFACE, :damageMods, 1.5)),
    PBFieldNote.new(19,"Becomes <c=orange>Underwater</c> when . . .","...when #{feToStringName(:WATERSURFACE, :fieldChange, :UNDERWATER)} is used."),
    PBFieldNote.new(19,"Becomes <c=orange>Icy Field</c> when . . .","...when #{feToStringName(:WATERSURFACE, :fieldChange, :ICY)} is used."),
    PBFieldNote.new(19,"Becomes <c=orange>Murkwater</c> when . . .","...when Acid Downpour is used, or Sludge Wave is used twice."),
    PBFieldNote.new(19,"Nature Power <icon=fieldChange> #{feToStringName(:WATERSURFACE, :naturePower)}"),
    PBFieldNote.new(19,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:WATERSURFACE, :mimicry))}> "),
    PBFieldNote.new(19,"Secret Power <icon=fieldChange> <c=red>lowers</c> Speed"),
    PBFieldNote.new(19,"Activates <c=orange>Elemental Seed</c> . . .","Boosts Sp.Def and applies Aqua Ring to the user."),
  #Underwater
    PBFieldNote.new(20,"<c=orange>\"#{FIELDEFFECTS.dig(:UNDERWATER, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(20,"Speed <icon=fieldDown> <c=red>x0.5</c> unless <icon=typeWATER> or . . .", "...unless Water type or Swift Swim is active."),
    PBFieldNote.new(20,"<c=red>Prevents</c> <icon=typeFIRE> attacks"),
    PBFieldNote.new(20,"<c=red>Prevents</c> generated Fields"),
    PBFieldNote.new(20,"All weather is <c=red>terminated</c> "),
    PBFieldNote.new(20,"<icon=typeWATER> attacks <icon=fieldChange>x1 vs <icon=typeWATER> types"),
    PBFieldNote.new(20,"Physical damage <icon=fieldDown> <c=red>x0.5</c> unless . . .", "...unless attack is Water type or user has Steelworker."),
    PBFieldNote.new(20,"End of turn <icon=typeWATER> <c=orange>damage</c> when . . .", "...when Pokémon is weak to Water."),
    PBFieldNote.new(20,"<c=green>Immunity</c> to <c=orange>field damage</c> when . . .","...when the abilities Magic Guard or Swift Swim are active."),
    PBFieldNote.new(20,"<c=orange>Field damage</c> <icon=fieldRedUp> when . . .","...when the abilities Magma Armor or Flame Body are active."),
    PBFieldNote.new(20,"Dive lasts 1 turn"),
    PBFieldNote.new(20,"Water Veil <icon=fieldPlus> <c=green>cures</c> status"),
    PBFieldNote.new(20,"<c=green>Activates</c> certain abilities . . .","Hydration, Schooling, Surge Surfer, Swift Swim, Torrent, and Water Compaction each turn."),
    PBFieldNote.new(20,"Aqua Ring recovery <icon=fieldChange> <c=green>1/8 HP</c> "),
    PBFieldNote.new(20,"Certain abilities <c=green>restore HP</c> . . .","Dry Skin, Water Absorb"),
    PBFieldNote.new(20,"Whirlpool damage <icon=fieldChange> <c=green>1/6 HP</c> "),
    PBFieldNote.new(20,"Whirlpool <icon=fieldPlus> confuses target"),
    PBFieldNote.new(20,"<icon=fieldGround> attacks <icon=fieldPlus> <icon=typeWATER> damage"),
    PBFieldNote.new(20,"<icon=typeWATER> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(20,"<icon=typeELECTRIC> attacks <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(20,"<icon=typeELECTRIC> attacks <icon=fieldUp> <c=green>never miss</c> "),
    PBFieldNote.new(20,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:UNDERWATER, :damageMods, 1.5)),
    PBFieldNote.new(20,"Certain attacks <icon=fieldUp> <c=green>x2</c> . . . ",feToStringName(:UNDERWATER, :damageMods, 2.0)),
    PBFieldNote.new(20,"Becomes <c=orange>Water Surface</c> when . . .","...when #{feToStringName(:UNDERWATER, :fieldChange, :WATERSURFACE)} is used."),
    PBFieldNote.new(20,"Becomes <c=orange>Murkwater</c> when . . .","...when Acid Downpour is used, or Sludge Wave is used twice, KOing all non-Poison or Steel type Pokémon."),
    PBFieldNote.new(20,"Nature Power <icon=fieldChange> #{feToStringName(:UNDERWATER, :naturePower)}"),
    PBFieldNote.new(20,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:UNDERWATER, :mimicry))}> "),
    PBFieldNote.new(20,"Secret Power <icon=fieldChange> <c=red>lowers</c> Attack"),
    PBFieldNote.new(20,"Activates <c=orange>Elemental Seed</c> . . .","Boosts Speed and applies Soak to the user."),
  #Cave
    PBFieldNote.new(21,"<c=orange>\"#{FIELDEFFECTS.dig(:CAVE, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(21,"<icon=fieldGround> attacks hit <icon=fieldFlying>/Levitate"),
    PBFieldNote.new(21,"Fly and Bounce last 1 turn"),
    PBFieldNote.new(21,"<c=red>Prevents</c> Sky Drop"),
    PBFieldNote.new(21,"Stealth Rock damage <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(21,"<icon=typeROCK> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(21,"<icon=fieldFlying> attacks <icon=fieldDown> <c=red>x0.5</c> when . . .","...when non-contact."),
    PBFieldNote.new(21,"Sound-based moves <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(21,"Rock Tomb <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(21,"Becomes <c=orange>Crystal Cavern</c> when . . .","...when #{feToStringName(:CAVE, :fieldChange, :CRYSTALCAVERN)} is used."),
    PBFieldNote.new(21,"Nature Power <icon=fieldChange> #{feToStringName(:CAVE, :naturePower)}"),
    PBFieldNote.new(21,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:CAVE, :mimicry))}> "),
    PBFieldNote.new(21,"Secret Power <icon=fieldChange> Flinches"),
    PBFieldNote.new(21,"Activates <c=orange>Telluric Seed</c> . . .","Boosts Defense by two stages and damages the user with Stealth Rocks."),
  #Cloud Field
    PBFieldNote.new(22,"<c=orange>\"#{FIELDEFFECTS.dig(:CLOUDS, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(22,"Certain attacks will always <c=red>fail</c> . . .",feToStringName(:CLOUDS, :damageMods, 0)),
    PBFieldNote.new(22,"Stealth Rocks bounce back to user"),
    PBFieldNote.new(22,"Tailwind lasts <c=green>5</c> turns"),
    PBFieldNote.new(22,"Rain and Hail last for <c=green>8</c> turns"),
    PBFieldNote.new(22,"<icon=typeFLYING> attacks <icon=fieldUp> <c=green>x1.3</c> "),
    PBFieldNote.new(22,"<icon=typeELECTRIC> attacks <icon=fieldDown> <c=red>x0.9</c> "),
    PBFieldNote.new(22,"<icon=typeROCK> attacks <icon=fieldDown> <c=red>x0.75</c> "),
    PBFieldNote.new(22,"Certain attacks <icon=fieldUp> <c=green>x1.2</c> ",feToStringName(:CLOUDS, :damageMods, 1.2)),
    PBFieldNote.new(22,"Bounce, Fly, Sky Attack, Razor Wind . . .","Last 1 turn"),
    PBFieldNote.new(22,"Certain stat moves' effect <icon=fieldUp> . . . ","Defog"),
    PBFieldNote.new(22,"Certain attacks's Accuracy <icon=fieldChange> <c=green>100</c> . . .","Bounce, Fly, Hurricane, Thunder"),
    PBFieldNote.new(22,"Cloud Nine <icon=fieldPlus> <c=green>boosts</c> stats . . .","Cloud Nine boosts Defense and Sp.Def upon switching in."),
    PBFieldNote.new(22,"Forecast <icon=fieldPlus> <c=green>boosts</c> stats . . .","Forecast boosts Defense, Sp.Def and Speed upon switching in."),
    PBFieldNote.new(22,"Overcoat <icon=fieldPlus> <c=green>boosts</c> Defense"),
    PBFieldNote.new(22,"Hydration <c=green>restores HP</c> each turn . . .","...when it's raining"),
    PBFieldNote.new(22,"Fluffy reduced damage <icon=fieldChange> <c=green>25%</c>"),
    PBFieldNote.new(22,"Nature Power <icon=fieldChange> #{feToStringName(:CLOUDS, :naturePower)}"),
    PBFieldNote.new(22,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:CLOUDS, :mimicry))}> "),
    PBFieldNote.new(22,"Secret Power <icon=fieldChange> <c=red>lowers</c> Accuracy"),
    PBFieldNote.new(22,"Activates <c=orange>Elemental Seed</c> . . .","Applies Protect to the user."),
  #Crystal Cavern
    PBFieldNote.new(23,"<c=orange>\"#{FIELDEFFECTS.dig(:CRYSTALCAVERN, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(23,"<icon=typeROCK> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(23,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> ",feToStringName(:CRYSTALCAVERN, :damageMods, 1.5)),
    PBFieldNote.new(23,"Certain attacks <icon=fieldPlus> extra type","Rock Type attacks, as well as Judgment, Multi-Attack, Rock Climb, and Strength gain a sequential typing between Fire, Water, Grass and Psychic in that repeating pattern."),
    PBFieldNote.new(23,"<icon=typeDRAGON> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(23,"Certain attacks <icon=fieldUp> <c=green>x1.3</c> ",feToStringName(:CRYSTALCAVERN, :damageMods, 1.3)),
    PBFieldNote.new(23,"Becomes a <c=orange>Cave</c> when . . .","...when #{feToStringName(:CRYSTALCAVERN, :fieldChange, :CAVE)} is used."),
    PBFieldNote.new(23,"Rock Polish <icon=fieldPlus> <c=green>boosts</c> Atk/Sp.Atk"),
    PBFieldNote.new(23,"Stealth Rock <icon=fieldPlus> random damage","Stealth Rock randomly applies either Fire, Water, Grass or Psychic type damage."),
    PBFieldNote.new(23,"<c=green>Enables</c> Aurora Veil"),
    PBFieldNote.new(23,"Prism Armor <c=green>lowers damage</c> x0.75"),
    PBFieldNote.new(23,"Nature Power <icon=fieldChange> #{feToStringName(:CRYSTALCAVERN, :naturePower)}"),
    PBFieldNote.new(23,"Camouflage, Mimicry <icon=fieldChange> random type . . .","Camouflage may choose one of Fire, Water, Grass or Psychic typings."),
    PBFieldNote.new(23,"Secret Power <icon=fieldChange> random status . . .","Secret Power may choose a random status between Burn, Freeze, Sleep or Confusion."),
    PBFieldNote.new(23,"Activates <c=orange>Magical Seed</c> . . .","Boosts Sp.Atk and applies Magic Coat to the user."),
  #Murkwater Surface
    PBFieldNote.new(24,"<c=orange>\"#{FIELDEFFECTS.dig(:MURKWATERSURFACE, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(24,"Speed <icon=fieldDown> <c=red>x0.75</c> unless <icon=typeWATER> or . . .", "...unless Water type, airborne, or the abilities Surge Surfer or Swift Swim are active."),
    PBFieldNote.new(24,"End of turn <icon=typePOISON> <c=orange>damage</c> when . . .","...when grounded, and not Poison or Steel type."),
    PBFieldNote.new(24,"<c=green>Immunity</c> to field <c=orange>damage</c> when . . .","...when one of the following abilities is active: Immunity, Magic Guard, Poison Heal, Toxic Boost, Wonder Guard"),
    PBFieldNote.new(24,"Field <c=orange>damage</c> <icon=fieldRedUp> when . . .","...when Pokémon is underwater (x4) or has one of the following abilities (x2): Dry Skin, Flame Body, Magma Armor, Water Absorb"),
    PBFieldNote.new(24,"Dry Skin <c=green>restores HP</c> when . . .","...when grounded and Poison type."),
    PBFieldNote.new(24,"Water Absorb <c=green>restores HP</c> when . . .","...when grounded and Poison type."),
    PBFieldNote.new(24,"<c=green>Activates</c> certain abilities when . . .","...when grounded, activates Merciless, Poison Heal, Schooling, Surge Surfer, Swift Swim, Toxic Boost and Water Compaction each turn."),
    PBFieldNote.new(24,"<c=red>Prevents</c> <icon=fieldGround> attacks"),
    PBFieldNote.new(24,"Spikes/Toxic Spikes <c=red>terminated</c> "),
    PBFieldNote.new(24,"Shore Up <c=green>activates</c> Water Compaction"),
    PBFieldNote.new(24,"<icon=typeWATER> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(24,"<icon=typeWATER> attacks <icon=fieldPlus> <icon=typePOISON> "),
    PBFieldNote.new(24,"<icon=typePOISON> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(24,"<icon=typeELECTRIC> attacks <icon=fieldUp> <c=green>x1.3</c> when . . .","...when opponent is grounded."),
    PBFieldNote.new(24,"Sludge Wave <icon=fieldPlus> <icon=typeWATER> "),
    PBFieldNote.new(24,"Certain attacks <icon=fieldChange> <icon=typeWATER> / <icon=typePOISON> ","Mud Bomb, Mud Shot, Mud-Slap, Thousand Waves"),
    PBFieldNote.new(24,"Certain attacks <icon=fieldPlus> <icon=typePOISON> . . .","Smack Down"),
    PBFieldNote.new(24,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:MURKWATERSURFACE, :damageMods, 1.5)),
    PBFieldNote.new(24,"Gooey effect <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(24,"Stench chance <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(24,"Acid Armor's effect <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(24,"<c=green>Activates</c> Venoshock"),
    PBFieldNote.new(24,"<c=green>Activates</c> Venom Drench"),
    PBFieldNote.new(24,"Liquid Ooze <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(24,"Becomes <c=orange>Water Surface</c> when . . .","...when #{feToStringName(:MURKWATERSURFACE, :fieldChange, :WATERSURFACE)} is used."),
    PBFieldNote.new(24,"Becomes <c=orange>Icy Field</c> when . . .","...when #{feToStringName(:MURKWATERSURFACE, :fieldChange, :ICY)} is used."),
    PBFieldNote.new(24,"Nature Power <icon=fieldChange> #{feToStringName(:MURKWATERSURFACE, :naturePower)}"),
    PBFieldNote.new(24,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:MURKWATERSURFACE, :mimicry))}> "),
    PBFieldNote.new(24,"Secret Power <icon=fieldChange> <icon=fieldPoisonStatus> "),
    PBFieldNote.new(24,"Activates <c=orange>Elemental Seed</c> . . .","Boosts Speed and applies Aqua Ring, but poisons the user."),
  #Mountain
    PBFieldNote.new(25,"<c=orange>\"Adieu to disappointment and spleen,\"</c> ", "What are men to rocks and mountains?"),
    PBFieldNote.new(25,"Tailwind lasts <c=green>5</c> turns"),
    PBFieldNote.new(25,"Tailwind <icon=fieldPlus> Strong Winds"),
    PBFieldNote.new(25,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:MOUNTAIN, :damageMods, 1.5)),
    PBFieldNote.new(25,"Certain attacks <icon=fieldPlus> <icon=fieldUp> <c=green>x1.5</c> when . . .","...when Strong Winds are active, further boosts all Special Flying attacks, as well as Fairy Wind, Gust, Icy Wind, Ominous Wind, Razor Wind, Silver Wind, Twister"),
    PBFieldNote.new(25,"Sun lasts <c=green>8</c> turns"),
    PBFieldNote.new(25,"Thunder <c=green>never misses</c> "),
    PBFieldNote.new(25,"Becomes <c=orange>Snowy Mountain</c> when . . .","...when #{feToStringName(:MOUNTAIN, :fieldChange, :SNOWYMOUNTAIN)} is used, or it has been hailing for 3 turns."),
    PBFieldNote.new(25,"<icon=fieldFlying> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(25,"<icon=typeROCK> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(25,"Long Reach damage <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(25,"<c=green>Activates</c> Gale Wings when windy"),
    PBFieldNote.new(25,"Aerilate power boost <icon=fieldChange> <c=green>x1.5</c> "),
    PBFieldNote.new(25,"Nature Power <icon=fieldChange> #{feToStringName(:MOUNTAIN, :naturePower)}"),
    PBFieldNote.new(25,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:MOUNTAIN, :mimicry))}> "),
    PBFieldNote.new(25,"Secret Power <icon=fieldChange> Flinches"),
    PBFieldNote.new(25,"Activates <c=orange>Telluric Seed</c> . . .","Boosts Attack by two stages, but lowers Accuracy."),
  #Snowy Mountain
    PBFieldNote.new(26,"<c=orange>\"The snow glows white on the mountain\"</c> "),
    PBFieldNote.new(26,"Tailwind lasts <c=green>5</c> turns"),
    PBFieldNote.new(26,"Tailwind <icon=fieldPlus> Strong Winds"),
    PBFieldNote.new(26,"<icon=typeROCK> attacks <icon=fieldPlus> <icon=fieldIce> "),
    PBFieldNote.new(26,"<icon=fieldIce> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(26,"<icon=typeROCK> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(26,"<icon=fieldFlying> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(26,"<icon=typeFIRE> attacks <icon=fieldDown> <c=red>x0.5</c> "),
    PBFieldNote.new(26,"<icon=fieldIce> Pokémon's Defense <icon=fieldUp> <c=green>x1.5</c> when . . .", "...when Hail is up"),
    PBFieldNote.new(26,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:SNOWYMOUNTAIN, :damageMods, 1.5)),
    PBFieldNote.new(26,"Certain attacks <icon=fieldPlus> <icon=fieldUp> <c=green>x1.5</c> when . . .","...when Strong Winds are active, further boosts all Special Flying attacks, as well as Fairy Wind, Gust, Icy Wind, Ominous Wind, Razor Wind, Silver Wind, Twister"),
    PBFieldNote.new(26,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ",feToStringName(:SNOWYMOUNTAIN, :damageMods, 0.5)),
    PBFieldNote.new(26,"Sun and Hail last for <c=green>8</c> turns"),
    PBFieldNote.new(26,"Thunder <c=green>never misses</c> "),
    PBFieldNote.new(26,"<c=green>Activates</c> certain abilities . . .","Ice Body, Slush Rush, Snow Cloak"),
    PBFieldNote.new(26,"Refrigerate power boost <icon=fieldChange> <c=green>x1.5</c> "),
    PBFieldNote.new(26,"Becomes a <c=orange>Mountain</c> when . . .", "...when #{feToStringName(:SNOWYMOUNTAIN, :fieldChange, :MOUNTAIN)} is used"),
    PBFieldNote.new(26,"<c=green>Activates</c> Gale Wings when windy"),
    PBFieldNote.new(26,"<c=green>Enables</c> Aurora Veil"),
    PBFieldNote.new(26,"Long Reach damage <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(26,"Aerilate power boost <icon=fieldChange> <c=green>x1.5</c> "),
    PBFieldNote.new(26,"Nature Power <icon=fieldChange> #{feToStringName(:SNOWYMOUNTAIN, :naturePower)}"),
    PBFieldNote.new(26,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:SNOWYMOUNTAIN, :mimicry))}> "),
    PBFieldNote.new(26,"Secret Power <icon=fieldChange> <icon=fieldFreeze> "),
    PBFieldNote.new(26,"Activates <c=orange>Telluric Seed</c> . . .","Boosts Sp.Atk by two stages, but lowers Accuracy."),
  #Holy Field
    PBFieldNote.new(27,"<c=orange>\"#{FIELDEFFECTS.dig(:HOLY, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(27,"The type chart is <c=orange>altered</c> . . .","Normal type attacks hit Ghost and Dark type Pokémon for super-effective damage."),
    PBFieldNote.new(27,"<icon=typeGHOST> attacks <icon=fieldDown> <c=red>x0.5</c> "),
    PBFieldNote.new(27,"Certain attacks <icon=fieldDown> <c=red>x0.5</c> . . . ","All special Dark type moves"),
    PBFieldNote.new(27,"Special <icon=typeFAIRY> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(27,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:HOLY, :damageMods, 1.5)),
    PBFieldNote.new(27,"Certain attacks <icon=fieldUp> <c=green>x1.3</c> . . . ",feToStringName(:HOLY, :damageMods, 1.3)),
    PBFieldNote.new(27,"<icon=fieldPsychic> attacks <icon=fieldUp> <c=green>x1.2</c> "),
    PBFieldNote.new(27,"<icon=typeDRAGON> attacks <icon=fieldUp> <c=green>x1.2</c> "),
    PBFieldNote.new(27,"Special <icon=typeNORMAL> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(27,"Justified effect <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(27,"Wish recovery <icon=fieldChange> <c=green>75 % HP</c> "),
    PBFieldNote.new(27,"<c=red>Prevents</c> Cursed Body"),
    PBFieldNote.new(27,"Lifts Curse each turn"),
    PBFieldNote.new(27,"Allies <c=green>avoid</c> damage from  . . ","...allies avoid damage from their partner's moves"),
    PBFieldNote.new(27,"Miracle Eye <icon=fieldPlus> <c=green>boost</c> Sp.Atk"),
    PBFieldNote.new(27,"Cosmic Power's effect <icon=fieldUp> "),
    PBFieldNote.new(27,"Nature's Madness damage <icon=fieldChange> <c=green>75 % HP</c> "),
    PBFieldNote.new(27,"RKS System <icon=fieldChange> <icon=typeDARK> "),
    PBFieldNote.new(27,"<c=red>Destroyed</c> by these moves . . .", feToStringName(:HOLY, :fieldChange, :INDOOR)),
    PBFieldNote.new(27,"Nature Power <icon=fieldChange> #{feToStringName(:HOLY, :naturePower)}"),
    PBFieldNote.new(27,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:HOLY, :mimicry))}> "),
    PBFieldNote.new(27,"Secret Power <icon=fieldChange> <c=red>lowers</c> Sp.Atk"),
    PBFieldNote.new(27,"Activates <c=orange>Magical Seed</c> . . .","Boosts Sp.Atk and applies Magic Coat to the user."),
  #Fairy Tale Field
    PBFieldNote.new(28,"<c=orange>\"#{FIELDEFFECTS.dig(:FAIRYTALE, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(28,"<icon=typeFAIRY> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(28,"<icon=fieldSteel> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(28,"<icon=typeDRAGON> attacks <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(28,"<icon=fieldSteel> attacks <icon=fieldChange> <c=green>x2</c> vs <icon=typeDRAGON> "),
    PBFieldNote.new(28,"<icon=typeFIRE> attacks <icon=fieldUp> <icon=fieldplus> <icon=typeDRAGON> "),
    PBFieldNote.new(28,"Certain abilities <icon=fieldPlus> Defense <icon=fieldUp> . . .","Battle Armor, Power of Alchemy and Shell Armor boost Defense upon switching in."),
    PBFieldNote.new(28,"Certain abilities <icon=fieldPlus> Sp.Def <icon=fieldUp> . . .","Magic Guard, Magic Bounce and Power of Alchemy boost Sp.Def upon switching in."),
    PBFieldNote.new(28,"Magician <icon=fieldPlus> Sp.Atk <icon=fieldUp> when . . .","Magician boosts Sp.Atk upon switching in."),
    PBFieldNote.new(28,"Fairy Aura <icon=fieldPlus> moves <c=green>never miss</c> "),
    PBFieldNote.new(28,"<c=green>Activates</c> Marvel Scale"),
    PBFieldNote.new(28,"Certain attacks <icon=fieldChange> <icon=fieldSteel> ","Cut, Sacred Sword, Secret Sword, Slash"),
    PBFieldNote.new(28,"Stance Change <c=orange>alters</c> stats . . .","Pokémon with Stance Change boost and lower Attack and Defense one stage when switching between respective forms."),
    PBFieldNote.new(28,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:FAIRYTALE, :damageMods, 1.5)),
    PBFieldNote.new(28,"Draining Kiss <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(28,"Certain attacks <icon=fieldPlus> <c=green>boost</c> stats . . .","Crafty Shield and Flower Shield additionally boost the user's Defense and Sp.Def one stage."),
    PBFieldNote.new(28,"Certain attacks <icon=fieldPlus> <c=green>protection</c> . . .","King's Shield additionally protects from non-damaging moves."),
    PBFieldNote.new(28,"King's Shield <icon=fieldPlus> <c=green>lowers</c> Sp.Atk"),
    PBFieldNote.new(28,"Certain stat moves' effect <icon=fieldUp> . . .","Acid Armor, Noble Roar, Swords Dance"),
    PBFieldNote.new(28,"Certain attacks <icon=fieldPlus> <c=green>cure</c> Sleep","Draining Kiss, Sweet Kiss"),
    PBFieldNote.new(28,"Wish recovery <icon=fieldChange> <c=green> 75 % HP</c> "),
    PBFieldNote.new(28,"Healing Wish <icon=fieldPlus> <c=green>boosts</c> stats . . .","Healing Wish boosts recipient's Attack and Special Attack"),
    PBFieldNote.new(28,"Miracle Eye <icon=fieldPlus> <c=green>boost</c> Sp.Atk"),
    PBFieldNote.new(28,"Forest's Curse <icon=fieldPlus> Curse effect"),
    PBFieldNote.new(28,"Floral Healing recovery <icon=fieldChange> <c=green>100 %</c> "),
    PBFieldNote.new(28,"Queenly Majesty damage <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(28,"Soul Heart also  <c=green>boosts</c> Sp.Def"),
    PBFieldNote.new(28,"Nature Power <icon=fieldChange> #{feToStringName(:FAIRYTALE, :naturePower)}"),
    PBFieldNote.new(28,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:FAIRYTALE, :mimicry))}> "),
    PBFieldNote.new(28,"Secret Power <icon=fieldChange> <icon=fieldSleep> "),
    PBFieldNote.new(28,"Activates <c=orange>Magical Seed</c> . . .","Applies King's Shield to the user."),
  #Dragon's Den
    PBFieldNote.new(29,"<c=orange>\"#{FIELDEFFECTS.dig(:DRAGONSDEN, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(29,"<icon=typeDRAGON> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(29,"<icon=typeFIRE> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(29,"<icon=typeWATER> attacks <icon=fieldDown> <c=red>x0.5</c> "),
    PBFieldNote.new(29,"<icon=fieldIce> attacks <icon=fieldDown> <c=red>x0.5</c> "),
    PBFieldNote.new(29,"<icon=typeDRAGON> Pokémon's defenses <icon=fieldUp> <c=green>x1.3</c>"),
    PBFieldNote.new(29,"<c=green>Activates</c> Marvel Scale"),
    PBFieldNote.new(29,"Multiscale <icon=fieldPlus> <c=green>protection</c> ","Multiscale additionally annulls user's Dragon type's weaknesses at all times"),
    PBFieldNote.new(29,"Shed Skin <icon=fieldPlus> <c=green>recovery</c> and . . . ","Shed Skin heals 25% on activation, and boosts Speed and Sp.Atk by one stage each while lowering Defense and Sp.Def one stage each. \nAlways activates."),
    PBFieldNote.new(29,"Certain attacks <icon=fieldPlus> <icon=typeFIRE> . . .","#{feToStringName(:DRAGONSDEN, :typeMods, :FIRE)}"),
    PBFieldNote.new(29,"Certain attacks <icon=fieldUp> <c=green>x2</c> . . . ",feToStringName(:DRAGONSDEN, :damageMods, 2.0)),
    PBFieldNote.new(29,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:DRAGONSDEN, :damageMods, 1.5)),
    PBFieldNote.new(29,"Magma Storm damage <icon=fieldChange> <c=green>1/6 HP</c> "),
    PBFieldNote.new(29,"Magma Armor <icon=fieldPlus> <c=green>boosts</c> stats . . .","Magma Armor boosts Defense and Sp.Def upon switching in."),
    PBFieldNote.new(29,"Magma Armor <icon=fieldPlus> <icon=typeFIRE> <c=red>immunity</c> "),
    PBFieldNote.new(29,"Certain stat moves' effect <icon=fieldUp> . . .","Dragon Dance, Noble Roar"),
    PBFieldNote.new(29,"Becomes a <c=orange>Cave</c> when . . .","...when Glaciate, Hydro Vortex, Oceanic Operetta, or Subzero Slammer is used, or when Muddy Water, Sparkling Aria, or Surf is used twice."),
    PBFieldNote.new(29,"Nature Power <icon=fieldChange> #{feToStringName(:DRAGONSDEN, :naturePower)}"),
    PBFieldNote.new(29,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:DRAGONSDEN, :mimicry))}> "),
    PBFieldNote.new(29,"Secret Power <icon=fieldChange> <icon=fieldBurn> "),
    PBFieldNote.new(29,"Activates <c=orange>Elemental Seed</c> . . .","Boosts Sp.Atk and applies Flash Fire's power boost to the user."),
  #Flower Garden Field
    PBFieldNote.new(30,"<c=orange>\"#{FIELDEFFECTS.dig(:FLOWERGARDEN1, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(30,"<c=orange>Grows</c> from <c=orange>Stage 1</c> to <c=orange>Stage 5</c> "),
    PBFieldNote.new(30,"Certain attacks <c=orange>grow</c> 1 <c=orange>Stage</c> . . .","Bloom Doom, Growth, Rain Dance, Rototiller, Sunny Day, Water Sport, Ingrain.\nAdditionally, these abilities grow the field one stage on switch-in: Drizzle, Drought, Flower Gift, Flower Veil"),
    PBFieldNote.new(30,"Cut and X-Scissor <c=red>reduces</c> <c=orange>Stage</c> by 1","","<c=ffb347>2</c>+"),
    PBFieldNote.new(30,"<c=green>Activates</c> certain abilities . . .","Flower Gift, Swarm","<c=7CFC00>1</c>+"),
    PBFieldNote.new(30,"Rototiller's effect <icon=fieldUp> ","","<c=7CFC00>1</c>+"),
    PBFieldNote.new(30,"Rototiller <icon=fieldPlus> <c=green>boosts</c> stats . . .","Rototiller additionally boosts user's Attack and Sp.Atk.","<c=7CFC00>1</c>+"),
    PBFieldNote.new(30,"Growth's effect <icon=fieldUp> . . .","Increases (x2,x3) at Stages (1,3)","<c=7CFC00>1</c>,<c=ec5800>3</c> "),
    PBFieldNote.new(30,"Cut <icon=fieldUp> <c=green>x1.5</c> ","","<c=ffb347>2</c>+"),
    PBFieldNote.new(30,"Cut <icon=fieldChange> <c=green>x2</c> vs <icon=fieldGrass> ","","<c=ffb347>2</c>+"),
    PBFieldNote.new(30,"<c=green>Activates</c> certain abilities . . . ","Harvest, Leaf Guard","<c=ffb347>2</c>+"),
    PBFieldNote.new(30,"Flower Shield <icon=fieldPlus> <c=green>boosts</c> stats . . .","Flower Shield additionally boosts Sp.Def and the user's Defense and Sp.Def.","<c=ffb347>2</c>+"),
    PBFieldNote.new(30,"Certain attack's Accuracy <icon=fieldChange> <c=green>85</c> ","Poison Powder, Sleep Powder, Stun Spore","<c=ffb347>2</c>+"),
    PBFieldNote.new(30,"Flower Veil <icon=fieldPlus> <c=green>reduces</c> damage . . .","Flower Veil passively reduces damage x0.5 to its user and allied Grass types.","<c=ec5800>3</c>+"),
    PBFieldNote.new(30,"Becomes a <c=orange>Burning Field</c> when . . .","#{feToStringName(:FLOWERGARDEN3, :fieldChange, :BURNING)} is used in the absence of Rain or Water Sport.","<c=ec5800>3</c>+"),
    PBFieldNote.new(30,"Sweet Scent <icon=fieldPlus> <c=green>lowers</c> defenses","","<c=ec5800>3</c>+"),
    PBFieldNote.new(30,"<icon=typeFIRE> attacks <icon=fieldUp> <c=green>x1.5</c> ","","<c=ec5800>3</c>+"),
    PBFieldNote.new(30,"Flower Shield's effect <icon=fieldUp> ","","<c=ec5800>3</c>+"),
    PBFieldNote.new(30,"<c=green>Activates</c> Chlorophyll","","<c=ff2800>4</c>+"),
    PBFieldNote.new(30,"Grass type's weaknesses are <c=green>annulled</c> ","","<c=ff2800>4</c>+"),
    PBFieldNote.new(30,"Certain attacks <c=green>hit all</c> opposing","Petal Blizzard, Petal Dance, and all Powder moves hit both opposing Pokémon at Stage 5.","<c=ff00ff>5</c> "),
    PBFieldNote.new(30,"<icon=fieldGrass> attacks <icon=fieldUp> ","Grass type attacks increase in base power (x1.1,x1.3,x1.5,x2) at Stages (2,3,4,5).","<c=ffb347>2</c>-<c=ff00ff>5</c> "),
    PBFieldNote.new(30,"Damage <icon=fieldDown> vs <icon=fieldGrass> Pokémon . . .","Grass type Pokémon take damage reduced to (x0.75,x0.67,x0.5) at Stages (3,4,5).","<c=ffb347>2</c>-<c=ff00ff>5</c> "),
    PBFieldNote.new(30,"<icon=typeBUG> attacks <icon=fieldUp> . . .","Bug type attacks increase in base power (x1.5,x2) at Stages (2,4).","<c=ffb347>2</c>,<c=ff2800>4</c> "),
    PBFieldNote.new(30,"Swarm effect <icon=fieldUp> . . .","Swarm increases Bug type attacks' power by (x1.8,x2) at Stages (3,5).","<c=ec5800>3</c>,<c=ff00ff>5</c> "),
    PBFieldNote.new(30,"<c=green>Activates</c> Overgrow when . . .","Overgrow activates at (66% HP, Any HP amount) at Stages (2,3).","<c=ffb347>2</c>,<c=ec5800>3</c> "),
    PBFieldNote.new(30,"Overgrow's effect <icon=fieldUp> . . .","Overgrow increases Grass type attacks' power by (x1.8,x2) at Stages (4,5).","<c=ff2800>4</c>,<c=ff00ff>5</c> "),
    PBFieldNote.new(30,"Sweet Scent's effect <icon=fieldUp> . . .","At Stage 3 and later, Sweet Scent additionally lowers Defense and Sp.Def. Sweet Scent's effect increases (x2,x3) at Stages (4,5).","<c=ff2800>4</c>,<c=ff00ff>5</c> "),
    PBFieldNote.new(30,"Ingrain's effect <icon=fieldUp> . . .","Ingrain's effect increases (x2,x4) at Stages (2,4).","<c=ffb347>2</c>,<c=ff2800>4</c> "),
    PBFieldNote.new(30,"Certain attacks <icon=fieldUp> . . .","Fleur Cannon, Petal Blizzard and Petal Dance increase (x1.2,x1.5) at Stages (3,4).","<c=ec5800>3</c>,<c=ff2800>4</c> "),
    PBFieldNote.new(30,"Infestation damage <icon=fieldUp> . . .","Infestation deals (1/6,1/4,1/3) Max HP Damage per turn at Stages (3,4,5).","<c=ec5800>3</c>-<c=ff00ff>5</c> "),
    PBFieldNote.new(30,"Floral Healing recovery <icon=fieldChange> <c=green>100 %</c> ","","<c=ec5800>3</c>+"),
    PBFieldNote.new(30,"Acid Downpour resets to <c=orange>Stage 1</c> "),
    PBFieldNote.new(30,"Nature Power <icon=fieldChange> Growth","","<c=7CFC00>1</c>-<c=ff2800>4</c> "),
    PBFieldNote.new(30,"Nature Power <icon=fieldChange> Petal Blizzard","","<c=ff00ff>5</c> "),
    PBFieldNote.new(30,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:FLOWERGARDEN1, :mimicry))}> "),
    PBFieldNote.new(30,"Secret Power <icon=fieldChange> <c=red>lowers</c> stats . . .", "Secret Power may lower Evasion. At Stage 3 and later additionally lowers Defense and Sp.Def. At Stage 5 this effect increases x2.","<c=7CFC00>1</c> <c=ec5800>3</c> <c=ff00ff>5</c> "),
    PBFieldNote.new(30,"Activates <c=orange>Synthetic Seed</c> . . .","Boosts Sp.Def and applies Ingrain to the user, makes the field grow 1 stage."),
  #Starlight Arena
    PBFieldNote.new(31,"<c=orange>\"#{FIELDEFFECTS.dig(:STARLIGHT, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(31,"<c=red>Destroyed</c> when . . .","...when Light That Burns The Sky is used."),
    PBFieldNote.new(31,"Weather <c=red>stops</c> boosts . . .","...when weather is up, the field power boosts to moves and types isn't applied"),
    PBFieldNote.new(31,"<icon=fieldPsychic> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(31,"<icon=typeFAIRY> attacks <icon=fieldUp> <c=green>x1.3</c> "),
    PBFieldNote.new(31,"<icon=typeDARK> attacks <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(31,"<icon=typeDARK> attacks <icon=fieldPlus> <icon=typeFAIRY> "),
    PBFieldNote.new(31,"Victory Star <icon=fieldPlus> <c=green>boosts</c> damage"),
    PBFieldNote.new(31,"Geomancy <icon=fieldChange> <c=green>no charge turn</c> "),
    PBFieldNote.new(31,"<c=green>Activates</c> Marvel Scale"),
    PBFieldNote.new(31,"Illuminate <icon=fieldPlus> <c=green>boosts</c> stats . . .","Illuminate boosts Sp.Atk upon switching in."),
    PBFieldNote.new(31,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:STARLIGHT, :damageMods, 1.5)),
    PBFieldNote.new(31,"Certain attacks <icon=fieldUp> <c=green>x2</c> . . . ",feToStringName(:STARLIGHT, :damageMods, 2.0)),
    PBFieldNote.new(31,"Doom Desire <icon=fieldUp> <c=green>x4</c> and <icon=fieldPlus> <icon=typeFIRE> "),
    PBFieldNote.new(31,"Certain attacks <icon=fieldChange> <icon=typeFAIRY> . . .","Solar Beam, Solar Blade"),
    PBFieldNote.new(31,"Certain stat moves' effect <icon=fieldUp> . . .","Cosmic Power, Flash"),
    PBFieldNote.new(31,"Wish recovery <icon=fieldChange> <c=green>75 % HP</c> "),
    PBFieldNote.new(31,"Certain attacks <icon=fieldPlus> <c=green>boost</c> stats","Healing Wish and Lunar Dance boost recipient's Attack and Special Attack"),
    PBFieldNote.new(31,"Moonlight recovery <icon=fieldChange> <c=green>75 % HP</c> "),
    PBFieldNote.new(31,"<c=green>Enables</c> Aurora Veil"),
    PBFieldNote.new(31,"Shadow Shield <c=green>reduces</c> damage","Shadow Shield reduces damage of super effective hits by 0.75"),
    PBFieldNote.new(31,"Nature Power <icon=fieldChange> #{feToStringName(:STARLIGHT, :naturePower)}"),
    PBFieldNote.new(31,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:STARLIGHT, :mimicry))}> "),
    PBFieldNote.new(31,"Secret Power <icon=fieldChange> <c=red>lowers</c> Sp.Def"),
    PBFieldNote.new(31,"Activates <c=orange>Magical Seed</c> . . .","Boosts Sp.Atk and applies Wish to the user."),
  #Inverse Field
    PBFieldNote.new(32,"<c=orange>\"#{FIELDEFFECTS.dig(:INVERSE, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(32,"The type chart is <c=orange> inverted</c> "),
    PBFieldNote.new(32,"<c=green>Created</c> by Topsy Turvy when . . .","...Created (3 turns) when the attacker does not hold an Everstone."),
    PBFieldNote.new(32,"Nature Power <icon=fieldChange> #{feToStringName(:INVERSE, :naturePower)}"),
    PBFieldNote.new(32,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:INVERSE, :mimicry))}> "),
    PBFieldNote.new(32,"Secret Power <icon=fieldChange> may confuse"),
    PBFieldNote.new(32,"Activates <c=orange>Magical Seed</c> . . .","Boosts all stats, but makes the user recharge."),
  #Chess Field
    PBFieldNote.new(33,"<c=orange>\"#{FIELDEFFECTS.dig(:CHESS, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(33,"Pokémon are assigned as <c=orange>Pieces</c> . . .","...based on specific criteria. A Pokémon can only be one Piece."),
    PBFieldNote.new(33,"<c=orange>Pawn</c> - Sent out first turn of battle","Overrides all other roles except Queen."),
    PBFieldNote.new(33,"<c=orange>Rook</c> - Highest stat is Def or Sp.Def "),
    PBFieldNote.new(33,"<c=orange>Bishop</c> - Highest stat is Atk or Sp.Atk"),
    PBFieldNote.new(33,"<c=orange>Knight</c> - Highest stat is Speed "),
    PBFieldNote.new(33,"<c=orange>Queen</c> - Final slot in party","Overrides all roles. One per team."),
    PBFieldNote.new(33,"<c=orange>King</c> - Holds King's Rock or lowest HP","Overrides Knight, Bishop and Rook. One per team."),
    PBFieldNote.new(33,"<c=orange>Pieces</c> gain the following effects:"),
    PBFieldNote.new(33,"<c=orange>Pawn</c> - <icon=fieldPlus> Focus Sash's effect"),
    PBFieldNote.new(33,"<c=orange>Rook</c> - Def and Sp.Def <icon=fieldUp> "),
    PBFieldNote.new(33,"<c=orange>Bishop</c> - Attack and Sp.Atk <icon=fieldUp> "),
    PBFieldNote.new(33,"<c=orange>Knight</c> - Deals <c=green>3x</c> damage to <c=orange>Queens</c> and", "...and deals 1.25x damage when using a move in double battle that targets both opponents."),
    PBFieldNote.new(33,"<c=orange>Queen</c> - Def, Sp.Def, and damage <icon=fieldUp> "),
    PBFieldNote.new(33,"<c=orange>King</c> - All attacks <icon=fieldPlus> 1 Priority"),
    PBFieldNote.new(33,"Certain moves <icon=fieldChange> <c=orange>Chess Attacks</c> ","#{CHESSMOVES.map {|id| getMoveName(id)}.sort.join(", ")}"),
    PBFieldNote.new(33,"<c=orange>Chess Attacks</c> <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(33,"<c=orange>Chess Attacks</c> <icon=fieldPlus> <icon=typeROCK> "),
    PBFieldNote.new(33,"<c=orange>Chess Attacks</c> <icon=fieldUp> <c=green>x2</c> when . . .", "...when the target has Oblivious, Simple, Unaware, Klutz, or is confused."),
    PBFieldNote.new(33,"<c=orange>Chess Attacks</c> <icon=fieldDown> <c=red>x0.5</c> when . . .", "...when the target has Adaptability, Synchronize, Anticipation or Telepathy."),
    PBFieldNote.new(33,"Trick Room lasts <c=green>8</c> turns . . ."),
    PBFieldNote.new(33,"Queenly Majesty damage <icon=fieldUp> <c=green>x1.5</c> "),
    PBFieldNote.new(33,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . .", feToStringName(:CHESS, :damageMods, 1.5)),
    PBFieldNote.new(33,"Certain stat moves' effect <icon=fieldUp> . . . ","Calm Mind, Nasty Plot"),
    PBFieldNote.new(33,"Certain attacks <icon=fieldPlus> <c=green>protection</c> . . .","King's Shield additionally protects from non-damaging moves."),
    PBFieldNote.new(33,"King's Shield <icon=fieldPlus> <c=green>lowers</c> Sp.Atk"),
    PBFieldNote.new(33,"<c=red>Destroyed</c> by these moves . . .",feToStringName(:CHESS, :fieldChange, :INDOOR)),
    PBFieldNote.new(33,"Nature Power <icon=fieldChange> #{feToStringName(:CHESS, :naturePower)}"),
    PBFieldNote.new(33,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:CHESS, :mimicry))}> "),
    PBFieldNote.new(33,"Secret Power <icon=fieldChange> <c=red>lowers</c> Defense"),
    PBFieldNote.new(33,"Activates <c=orange>Synthetic Seed</c>. . .","Boosts Sp.Atk and applies Magic Coat to the user."),
  #Wasteland
    PBFieldNote.new(34,"<c=orange>\"#{FIELDEFFECTS.dig(:WASTELAND, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(34,"Entry hazards are <c=orange>consumed</c> . . .","Consumed hazards return at the end of the turn, returning a special effect to the side they were on: \n Stealth Rocks deal type-scaling Rock damage double the normal effect to Pokémon. \n Spikes deal 33% max HP to grounded Pokémon. \n Toxic Spikes deal 12.5% max HP to grounded non-Poison/Steel types, and inflicts Poison. \n Sticky Web severely lowers Pokémon's Speed."),
    PBFieldNote.new(34,"Certain attacks <icon=fieldUp> <c=green>x1.2</c> . . . ",feToStringName(:WASTELAND, :damageMods, 1.2)),
    PBFieldNote.new(34,"Certain attacks <icon=fieldUp> <c=green>x1.5</c> . . . ",feToStringName(:WASTELAND, :damageMods, 1.5)),
    PBFieldNote.new(34,"Certain attacks <icon=fieldDown> <c=red>x0.25</c> . . . ",feToStringName(:WASTELAND, :damageMods, 0.25)),
    PBFieldNote.new(34,"Certain attacks <icon=fieldPlus> <icon=typePOISON> . . .",feToStringName(:WASTELAND, :typeMods, :POISON)),
    PBFieldNote.new(34,"Certain moves <icon=fieldPlus> random status . . .","Acid Downpour, Gunk Shot, Octazooka, Sludge, Sludge Bomb, Sludge Wave inflict a random status unless target has Poison or Steel type, or one of these abilities: Immunity, Poison Heal, Toxic Boost"),
    PBFieldNote.new(34,"Certain abilities' chance <icon=fieldUp> <c=green>x2</c> ","Effect Spore, Poison Point, Stench"),
    PBFieldNote.new(34,"Liquid Ooze damage <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(34,"<c=green>Activates</c> certain abilities . . .", "Poison Heal, Toxic Boost, Merciless"),
    PBFieldNote.new(34,"Gooey effect <icon=fieldPlus> <icon=fieldPoisonStatus> "),
    PBFieldNote.new(34,"<c=green>Activates</c> Venom Drench and Venoshock"),
    PBFieldNote.new(34,"Spit Up <icon=fieldUp> <c=green>x2</c> "),
    PBFieldNote.new(34,"Swallow <icon=fieldUp> <c=green>x2</c> <icon=fieldPlus> <c=green>cure</c> when max stack"),
    PBFieldNote.new(34,"Leech Seed effect <icon=fieldUp> <c=green>x2</c>"),
    PBFieldNote.new(34,"Corrosion attacks <icon=fieldPlus> <icon=fieldAllStat> "),
    PBFieldNote.new(34,"Nature Power <icon=fieldChange> #{feToStringName(:WASTELAND, :naturePower)}"),
    PBFieldNote.new(34,"Camouflage, Mimicry <icon=fieldChange> <icon=field#{getTypeName(FIELDEFFECTS.dig(:WASTELAND, :mimicry))}> "),
    PBFieldNote.new(34,"Secret Power <icon=fieldChange> <icon=fieldAllStat> "),
    PBFieldNote.new(34,"Activates <c=orange>Telluric Seed</c> . . .","Boosts Attack and Sp.Atk and lays Stealth Rocks on both sides of the battle."),
  #Glitch Field
    PBFieldNote.new(35,"<c=orange>\"#{FIELDEFFECTS.dig(:GLITCH, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(35,"Type attacks <icon=fieldChange> always Physical . . .","Normal, Fighting, Poison, Ground, Flying, Bug, Rock, Ghost."),
    PBFieldNote.new(35,"Type attacks <icon=fieldChange> always Special . . .","Fire, Water, Grass, Electric, Ice, Psychic, Dragon."),
    PBFieldNote.new(35,"Special attacks <c=orange>calculate</c> on . . .","Special Attacks, for both the attacker and defender, calculate off of the higher stat between Sp.Atk and Sp.Def."),
    PBFieldNote.new(35,"<icon=typeDARK>, <icon=fieldSteel>, <icon=typeFAIRY> moves <icon=fieldChange> <icon=typeNORMAL> "),
    PBFieldNote.new(35,"The type chart is <c=orange>altered</c> . . .","Dragon always deals neutral damage. Bug now hits Poison types super-effectively. Ice now hits Fire types neutrally. Ghost now cannot hit Psychic types. Poison now hits Bug types super-effectively."),
    PBFieldNote.new(35,"Critical hit chance <icon=fieldUp> when . . .","Critical hit rate increases by one stage if attacker is faster than the target."),
    PBFieldNote.new(35,"Rage <c=red>locks</c> user into itself"),
    PBFieldNote.new(35,"Recharge moves don't have <c=green>recharge</c>. . .","...when the move knocks out a Pokémon"),
    PBFieldNote.new(35,"<icon=fieldPsychic> attacks <icon=fieldUp> <c=green>x1.2</c> "),
    PBFieldNote.new(35,"Blizzard's Accuracy <icon=fieldChange> <c=green>90</c> "),
    PBFieldNote.new(35,"Metronome <c=green>selects</c> attacks . . .","...selects attacks of 70 base power or higher only."),
    PBFieldNote.new(35,"Self-KO attacks <c=green>halve</c> Defense"),
    PBFieldNote.new(35,"RKS System <icon=fieldChange> <icon=typeQMARK> "),
    PBFieldNote.new(35,"<c=green>Created</c> when . . .", "Created for 5 turns when Conversion and Conversion2 are used in succession."),
    PBFieldNote.new(35,"Nature Power <icon=fieldChange> #{feToStringName(:GLITCH, :naturePower)}"),
    PBFieldNote.new(35,"Camouflage, Mimicry <icon=fieldChange> <icon=typeQMARK> "),
    PBFieldNote.new(35,"Secret Power <icon=fieldChange> <c=red>lowers</c> Speed"),
    PBFieldNote.new(35,"Activates <c=orange>Synthetic Seed</c> . . .","Boosts Defense and makes user ??? type."),
  #Crowd Field
    PBFieldNote.new(36,"<c=orange>\"#{FIELDEFFECTS.dig(:CROWD, :fieldMessage)[0]}\"</c> "),
    PBFieldNote.new(36,"Cheers and boos . . .","Cheers and boos can be heard when certain attacks are used." ),
    PBFieldNote.new(36,"When a cheer is heard . . .","Boosts the stat of the user in the following order and cycles through: Highest Attack or Sp.Atk stat, Highest Defense or Sp.Def stat, Speed." ),
    PBFieldNote.new(36,"When a boo is heard . . .","Lowers the user's highest stat based on their base stat total." ),
    PBFieldNote.new(36,"Comeback . . .","When a Pokemon claims a certain amount of multiple knockouts in a battle, the opposing Pokemon's stats will be raised based on the total number of knockouts." ),
    PBFieldNote.new(36,"<icon=typeFIGHTING> attacks <icon=fieldUp> <c=green>x1.3</c> ","A cheer is heard..." ),
    PBFieldNote.new(36,"Special <icon=typePSYCHIC> attacks <icon=fieldDown> <c=red>x0.8</c> ","A boo is heard..."),
    PBFieldNote.new(36,"Certain attacks <icon=fieldUp> <c=green>x1.2</c> . . . ","A cheer is heard for the following moves: #{feToStringName(:CROWD, :damageMods, 1.2)}"),
    PBFieldNote.new(36,"Certain stat moves' effect <icon=fieldUp> . . . ","Bulk Up, Work Up"),
    PBFieldNote.new(36,"Block <icon=fieldChange> also <c=>lowers</c> Speed "),
    PBFieldNote.new(36,"Rest lasts 1 turn"),
    PBFieldNote.new(36,"Iron Fist <icon=fieldPlus> <c=green>boosts</c> stats . . .","Iron Fist boosts Defense upon switching in."),
    PBFieldNote.new(36,"Guts <icon=fieldChange> . . .","Does not take damage from Poison or Burn"),
    PBFieldNote.new(36,"Intimidate <icon=fieldChange> also <c=>lowers</c> Defense "),
    PBFieldNote.new(36,"Nature Power <icon=fieldChange> #{feToStringName(:CROWD, :naturePower)}"),
    PBFieldNote.new(36,"Camouflage, Mimicry <icon=fieldChange> <icon=typeFIGHTING> "),
    PBFieldNote.new(36,"Secret Power <icon=fieldChange> <c=red>lowers</c> Defense"),
    PBFieldNote.new(36,"Activates <c=orange>Synthetic Seed</c> . . .","A cheer is heard and applies Mind Reader to the user."),
  #Dance Floor Field
    PBFieldNote.new(37,"<c=orange>\"The dance floor beckons . . .</c> ","The dance floor beckons... it's time to bust a move!"),
    PBFieldNote.new(37,"<icon=typePSYCHIC> attacks <icon=fieldUp> <c=green>x1.3</c> "),
    PBFieldNote.new(37,"Reflect, Light Screen last 8 turns"),
    PBFieldNote.new(37,"Certain attacks <icon=fieldUp> <c=green>x1.4</c> . . . ",feToStringName(:DANCEFLOOR, :damageMods, 1.4)),
    PBFieldNote.new(37,"Certain attacks <icon=fieldUp> <c=green>x1.2</c> . . . ",feToStringName(:DANCEFLOOR, :damageMods, 1.2)),
    PBFieldNote.new(37,"Certain stat moves' effect <icon=fieldUp> . . . ","Dragon Dance, Quiver Dance, Swords Dance, Feather Dance, Lunar Dance, Teeter Dance, Kinesis"),
    PBFieldNote.new(37,"Kinesis <icon=fieldChange> also <c=>lowers</c> Sp.Def "),
    PBFieldNote.new(37,"Teeter Dance <icon=fieldChange> also <c=>lowers</c> Defense "),
    PBFieldNote.new(37,"Certain abilities <icon=fieldPlus> Sp.Def <icon=fieldUp> . . .","Magic Guard, Magic Bounce and Magician boost Sp.Def upon switching in."),
    PBFieldNote.new(37,"Dancer <icon=fieldPlus> <c=green>boosts</c> stats . . .","Dancer boosts Sp.Atk upon switching in."),
    PBFieldNote.new(37,"Insomnia <icon=fieldPlus> <c=green>boosts</c> stats . . .","Insomnia boosts Defense and Sp.Def upon switching in."),
    PBFieldNote.new(37,"Illuminate <icon=fieldPlus> <c=green>boosts</c> stats . . .","Illuminate boosts Sp.Atk and Sp.Def upon switching in."),
    PBFieldNote.new(37,"Nature Power <icon=fieldChange> #{feToStringName(:DANCEFLOOR, :naturePower)}"),
    PBFieldNote.new(37,"Camouflage, Mimicry <icon=fieldChange> <icon=typePSYCHIC> "),
    PBFieldNote.new(37,"Secret Power <icon=fieldChange> <c=red>lowers</c> Sp.Def"),
    PBFieldNote.new(37,"Activates <c=orange>Synthetic Seed</c> . . .","Changes user's ability to Dancer."),
  ]

  File.open("Data/fieldnotes.dat","wb"){|file|
    Marshal.dump(all_field_notes,file)
  }
end
